/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.policy;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpPipelineNextPolicy;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.HttpPipelinePolicy;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class AddHeadersFromContextPolicy
implements HttpPipelinePolicy {
    public static final String AZURE_REQUEST_HTTP_HEADERS_KEY = "azure-http-headers-key";

    @Override
    public Mono<HttpResponse> process(HttpPipelineCallContext context, HttpPipelineNextPolicy next) {
        context.getData(AZURE_REQUEST_HTTP_HEADERS_KEY).ifPresent(headers -> {
            if (headers instanceof HttpHeaders) {
                HttpHeaders customHttpHeaders = (HttpHeaders)headers;
                for (HttpHeader httpHeader : customHttpHeaders) {
                    if (Objects.isNull(httpHeader.getName()) || Objects.isNull(httpHeader.getValue())) continue;
                    context.getHttpRequest().getHeaders().put(httpHeader.getName(), httpHeader.getValue());
                }
            }
        });
        return next.process();
    }
}

