/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.channel;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.socket.DatagramPacket;
import java.net.SocketAddress;
import java.time.Duration;
import javax.annotation.Nullable;
import reactor.netty.channel.ChannelMetricsRecorder;

public class ChannelMetricsHandler
extends ChannelDuplexHandler {
    final ChannelMetricsRecorder recorder;
    final SocketAddress remoteAddress;
    final boolean onServer;

    ChannelMetricsHandler(ChannelMetricsRecorder recorder, @Nullable SocketAddress remoteAddress, boolean onServer) {
        this.recorder = recorder;
        this.remoteAddress = remoteAddress;
        this.onServer = onServer;
    }

    public void channelRegistered(ChannelHandlerContext ctx) {
        if (!this.onServer) {
            ctx.pipeline().addAfter("reactor.left.channelMetricsHandler", "reactor.left.connectMetricsHandler", (ChannelHandler)new ConnectMetricsHandler(this.recorder));
        }
        ctx.fireChannelRegistered();
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        DatagramPacket p;
        ByteBuf buffer;
        if (msg instanceof ByteBuf) {
            ByteBuf buffer2 = (ByteBuf)msg;
            if (buffer2.readableBytes() > 0) {
                this.recorder.recordDataReceived(this.remoteAddress, buffer2.readableBytes());
            }
        } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
            if (this.remoteAddress != null) {
                this.recorder.recordDataReceived(this.remoteAddress, buffer.readableBytes());
            } else {
                this.recorder.recordDataReceived(p.sender(), buffer.readableBytes());
            }
        }
        ctx.fireChannelRead(msg);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        DatagramPacket p;
        ByteBuf buffer;
        if (msg instanceof ByteBuf) {
            ByteBuf buffer2 = (ByteBuf)msg;
            if (buffer2.readableBytes() > 0) {
                this.recorder.recordDataSent(this.remoteAddress, buffer2.readableBytes());
            }
        } else if (msg instanceof DatagramPacket && (buffer = (ByteBuf)(p = (DatagramPacket)msg).content()).readableBytes() > 0) {
            if (this.remoteAddress != null) {
                this.recorder.recordDataSent(this.remoteAddress, buffer.readableBytes());
            } else {
                this.recorder.recordDataSent(p.recipient(), buffer.readableBytes());
            }
        }
        ctx.write(msg, promise);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        if (this.remoteAddress != null) {
            this.recorder.incrementErrorsCount(this.remoteAddress);
        } else {
            this.recorder.incrementErrorsCount(ctx.channel().remoteAddress());
        }
        ctx.fireExceptionCaught(cause);
    }

    public ChannelMetricsRecorder recorder() {
        return this.recorder;
    }

    static final class ConnectMetricsHandler
    extends ChannelOutboundHandlerAdapter {
        final ChannelMetricsRecorder recorder;

        ConnectMetricsHandler(ChannelMetricsRecorder recorder) {
            this.recorder = recorder;
        }

        public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) throws Exception {
            long connectTimeStart = System.nanoTime();
            super.connect(ctx, remoteAddress, localAddress, promise);
            promise.addListener(future -> {
                ctx.pipeline().remove((ChannelHandler)this);
                String status = future.isSuccess() ? "SUCCESS" : "ERROR";
                this.recorder.recordConnectTime(remoteAddress, Duration.ofNanos(System.nanoTime() - connectTimeStart), status);
            });
        }
    }
}

