/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.connectors;

import java.util.BitSet;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IPartitionWriterFactory;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.ITupleMultiPartitionComputer;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.std.connectors.AbstractPartitionDataWriter;

public class MultiPartitionDataWriter
extends AbstractPartitionDataWriter {
    private final ITupleMultiPartitionComputer tpc;

    public MultiPartitionDataWriter(IHyracksTaskContext ctx, int consumerPartitionCount, IPartitionWriterFactory pwFactory, RecordDescriptor recordDescriptor, ITupleMultiPartitionComputer tpc) throws HyracksDataException {
        super(ctx, consumerPartitionCount, pwFactory, recordDescriptor);
        this.tpc = tpc;
    }

    @Override
    public void open() throws HyracksDataException {
        super.open();
        this.tpc.initialize();
    }

    @Override
    protected void processTuple(int tupleIndex) throws HyracksDataException {
        BitSet partitionSet = this.tpc.partition((IFrameTupleAccessor)this.tupleAccessor, tupleIndex, this.consumerPartitionCount);
        int p = partitionSet.nextSetBit(0);
        while (p >= 0) {
            this.appendToPartitionWriter(tupleIndex, p);
            p = partitionSet.nextSetBit(p + 1);
        }
    }
}

