/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.writers;

import java.io.PrintStream;
import org.apache.hyracks.algebricks.data.IAWriter;
import org.apache.hyracks.algebricks.data.IAWriterFactory;
import org.apache.hyracks.algebricks.data.IPrinter;
import org.apache.hyracks.algebricks.data.IPrinterFactory;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;

public class PrinterBasedWriterFactory
implements IAWriterFactory {
    private static final long serialVersionUID = 1L;
    public static final PrinterBasedWriterFactory INSTANCE = new PrinterBasedWriterFactory();

    public IAWriter createWriter(final int[] fields, final PrintStream printStream, IPrinterFactory[] printerFactories, RecordDescriptor inputRecordDescriptor) {
        final IPrinter[] printers = new IPrinter[printerFactories.length];
        for (int i = 0; i < printerFactories.length; ++i) {
            printers[i] = printerFactories[i].createPrinter();
        }
        return new IAWriter(){

            public void init() throws HyracksDataException {
                for (int i = 0; i < printers.length; ++i) {
                    printers[i].init();
                }
            }

            public void printTuple(IFrameTupleAccessor tAccess, int tIdx) throws HyracksDataException {
                for (int i = 0; i < fields.length; ++i) {
                    int fldStart = tAccess.getTupleStartOffset(tIdx) + tAccess.getFieldSlotsLength() + tAccess.getFieldStartOffset(tIdx, fields[i]);
                    int fldLen = tAccess.getFieldLength(tIdx, fields[i]);
                    if (i > 0) {
                        printStream.print("; ");
                    }
                    printers[i].print(tAccess.getBuffer().array(), fldStart, fldLen, printStream);
                }
                printStream.println();
            }
        };
    }
}

