/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.lang.sqlpp.clause;

import java.util.Objects;
import org.apache.asterix.common.exceptions.CompilationException;
import org.apache.asterix.lang.common.base.AbstractClause;
import org.apache.asterix.lang.common.base.Clause;
import org.apache.asterix.lang.common.base.Expression;
import org.apache.asterix.lang.common.visitor.base.ILangVisitor;
import org.apache.asterix.lang.sqlpp.visitor.base.ISqlppVisitor;

public class Projection
extends AbstractClause {
    private Expression expr;
    private String name;
    private boolean star;
    private boolean varStar;

    public Projection(Expression expr, String name, boolean star, boolean varStar) {
        this.expr = expr;
        this.name = name;
        this.star = star;
        this.varStar = varStar;
    }

    public <R, T> R accept(ILangVisitor<R, T> visitor, T arg) throws CompilationException {
        return ((ISqlppVisitor)visitor).visit(this, arg);
    }

    public Clause.ClauseType getClauseType() {
        return Clause.ClauseType.PROJECTION;
    }

    public Expression getExpression() {
        return this.expr;
    }

    public void setExpression(Expression expr) {
        this.expr = expr;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean hasName() {
        return this.name != null;
    }

    public boolean star() {
        return this.star;
    }

    public boolean varStar() {
        return this.varStar;
    }

    public String toString() {
        return this.star ? "*" : String.valueOf(this.expr) + (String)(this.varStar ? ".*" : (this.hasName() ? " as " + this.getName() : ""));
    }

    public int hashCode() {
        return Objects.hash(this.expr, this.varStar, this.name, this.star);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof Projection)) {
            return false;
        }
        Projection target = (Projection)((Object)object);
        return Objects.equals(this.expr, target.expr) && Objects.equals(this.name, target.name) && this.varStar == target.varStar && this.star == target.star;
    }
}

