/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.com.job.profiling.counters;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.hyracks.api.job.profiling.counters.ICounter;

public class Counter
implements ICounter {
    private static final long serialVersionUID = -3935601595055562080L;
    private final String name;
    private final AtomicLong counter;

    public Counter(String name) {
        this.name = name;
        this.counter = new AtomicLong();
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public long update(long delta) {
        return this.counter.addAndGet(delta);
    }

    @Override
    public long set(long value) {
        long oldValue = this.counter.get();
        this.counter.set(value);
        return oldValue;
    }

    @Override
    public long get() {
        return this.counter.get();
    }
}

