/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.formats.nontagged.SerializerDeserializerProvider;
import org.apache.asterix.om.base.AInt64;
import org.apache.asterix.om.base.AMutableInt64;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.common.NumberUtils;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.exceptions.InvalidDataFormatException;
import org.apache.asterix.runtime.exceptions.TypeMismatchException;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractInt64ConstructorEvaluator
implements IScalarEvaluator {
    protected static final ISerializerDeserializer<AInt64> INT64_SERDE = SerializerDeserializerProvider.INSTANCE.getSerializerDeserializer((Object)BuiltinType.AINT64);
    protected final IScalarEvaluator inputEval;
    protected final SourceLocation sourceLoc;
    protected final IPointable inputArg;
    protected final ArrayBackedValueStorage resultStorage;
    protected final DataOutput out;
    protected final AMutableInt64 aInt64;
    protected final UTF8StringPointable utf8Ptr;

    protected AbstractInt64ConstructorEvaluator(IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        this.inputEval = inputEval;
        this.sourceLoc = sourceLoc;
        this.inputArg = new VoidPointable();
        this.resultStorage = new ArrayBackedValueStorage();
        this.out = this.resultStorage.getDataOutput();
        this.aInt64 = new AMutableInt64(0L);
        this.utf8Ptr = new UTF8StringPointable();
    }

    public void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        try {
            this.inputEval.evaluate(tuple, this.inputArg);
            this.resultStorage.reset();
            if (PointableHelper.checkAndSetMissingOrNull(result, this.inputArg)) {
                return;
            }
            this.evaluateImpl(result);
        }
        catch (IOException e) {
            throw new InvalidDataFormatException(this.sourceLoc, this.getIdentifier(), e, ATypeTag.SERIALIZED_INT64_TYPE_TAG);
        }
    }

    protected void evaluateImpl(IPointable result) throws IOException {
        int startOffset;
        byte[] bytes = this.inputArg.getByteArray();
        byte tt = bytes[startOffset = this.inputArg.getStartOffset()];
        if (tt == ATypeTag.SERIALIZED_INT64_TYPE_TAG) {
            result.set((IValueReference)this.inputArg);
        } else if (tt == ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            this.utf8Ptr.set(bytes, startOffset + 1, this.inputArg.getLength() - 1);
            if (NumberUtils.parseInt64(this.utf8Ptr, this.aInt64)) {
                INT64_SERDE.serialize((Object)this.aInt64, this.out);
                result.set((IValueReference)this.resultStorage);
            } else {
                this.handleUnparseableString(result);
            }
        } else {
            throw new TypeMismatchException(this.sourceLoc, this.getIdentifier(), 0, tt, ATypeTag.SERIALIZED_STRING_TYPE_TAG);
        }
    }

    protected void handleUnparseableString(IPointable result) throws HyracksDataException {
        throw new InvalidDataFormatException(this.sourceLoc, this.getIdentifier(), ATypeTag.SERIALIZED_INT64_TYPE_TAG);
    }

    protected abstract FunctionIdentifier getIdentifier();
}

