/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

public abstract class AbstractBinaryStringEval
implements IScalarEvaluator {
    private final IEvaluatorContext ctx;
    private final IScalarEvaluator evalLeft;
    private final IScalarEvaluator evalRight;
    private final IPointable argPtrLeft = new VoidPointable();
    private final IPointable argPtrSecond = new VoidPointable();
    private final UTF8StringPointable leftStringPointable = new UTF8StringPointable();
    private final UTF8StringPointable rightStringPointable = new UTF8StringPointable();
    protected final ArrayBackedValueStorage resultStorage = new ArrayBackedValueStorage();
    protected final DataOutput dataOutput = this.resultStorage.getDataOutput();
    private final FunctionIdentifier funcID;
    protected final SourceLocation sourceLoc;

    public AbstractBinaryStringEval(IEvaluatorContext context, IScalarEvaluatorFactory evalLeftFactory, IScalarEvaluatorFactory evalRightFactory, FunctionIdentifier funcID, SourceLocation sourceLoc) throws HyracksDataException {
        this.sourceLoc = sourceLoc;
        this.evalLeft = evalLeftFactory.createScalarEvaluator(context);
        this.evalRight = evalRightFactory.createScalarEvaluator(context);
        this.funcID = funcID;
        this.ctx = context;
    }

    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
        this.resultStorage.reset();
        this.evalLeft.evaluate(tuple, this.argPtrLeft);
        this.evalRight.evaluate(tuple, this.argPtrSecond);
        if (PointableHelper.checkAndSetMissingOrNull(resultPointable, this.argPtrLeft, this.argPtrSecond)) {
            return;
        }
        byte[] bytes0 = this.argPtrLeft.getByteArray();
        int offset0 = this.argPtrLeft.getStartOffset();
        int len0 = this.argPtrLeft.getLength();
        byte[] bytes1 = this.argPtrSecond.getByteArray();
        int offset1 = this.argPtrSecond.getStartOffset();
        int len1 = this.argPtrSecond.getLength();
        if (bytes0[offset0] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            PointableHelper.setNull(resultPointable);
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.sourceLoc, (FunctionIdentifier)this.funcID, (byte)bytes0[offset0], (int)0, (ATypeTag)ATypeTag.STRING);
            return;
        }
        if (bytes1[offset1] != ATypeTag.SERIALIZED_STRING_TYPE_TAG) {
            PointableHelper.setNull(resultPointable);
            ExceptionUtil.warnTypeMismatch((IEvaluatorContext)this.ctx, (SourceLocation)this.sourceLoc, (FunctionIdentifier)this.funcID, (byte)bytes1[offset1], (int)1, (ATypeTag)ATypeTag.STRING);
            return;
        }
        this.leftStringPointable.set(bytes0, offset0 + 1, len0 - 1);
        this.rightStringPointable.set(bytes1, offset1 + 1, len1 - 1);
        try {
            this.process(this.leftStringPointable, this.rightStringPointable, resultPointable);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    protected abstract void process(UTF8StringPointable var1, UTF8StringPointable var2, IPointable var3) throws IOException;
}

