/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.serde;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.apache.asterix.om.base.AInterval;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.hyracks.api.dataflow.value.ISerializerDeserializer;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.primitive.BytePointable;
import org.apache.hyracks.data.std.primitive.IntegerPointable;
import org.apache.hyracks.data.std.primitive.LongPointable;

public class AIntervalSerializerDeserializer
implements ISerializerDeserializer<AInterval> {
    private static final long serialVersionUID = 1L;
    public static final AIntervalSerializerDeserializer INSTANCE = new AIntervalSerializerDeserializer();

    private AIntervalSerializerDeserializer() {
    }

    public AInterval deserialize(DataInput in) throws HyracksDataException {
        try {
            long end;
            long start;
            byte tag = in.readByte();
            if (tag == ATypeTag.DATETIME.serialize()) {
                start = in.readLong();
                end = in.readLong();
            } else {
                start = in.readInt();
                end = in.readInt();
            }
            return new AInterval(start, end, tag);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public void serialize(AInterval instance, DataOutput out) throws HyracksDataException {
        try {
            out.writeByte(instance.getIntervalType());
            if (instance.getIntervalType() == ATypeTag.DATETIME.serialize()) {
                out.writeLong(instance.getIntervalStart());
                out.writeLong(instance.getIntervalEnd());
            } else {
                out.writeInt((int)instance.getIntervalStart());
                out.writeInt((int)instance.getIntervalEnd());
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static byte getIntervalTimeType(byte[] data, int start) {
        return BytePointable.getByte((byte[])data, (int)start);
    }

    private static int getTypeSize() {
        return 1;
    }

    public static long getIntervalStart(byte[] data, int start) {
        if (AIntervalSerializerDeserializer.getIntervalTimeType(data, start) == ATypeTag.DATETIME.serialize()) {
            return LongPointable.getLong((byte[])data, (int)AIntervalSerializerDeserializer.getIntervalStartOffset(start));
        }
        return IntegerPointable.getInteger((byte[])data, (int)AIntervalSerializerDeserializer.getIntervalStartOffset(start));
    }

    public static int getIntervalStartOffset(int start) {
        return start + AIntervalSerializerDeserializer.getTypeSize();
    }

    public static int getStartSize(byte[] data, int start) {
        if (AIntervalSerializerDeserializer.getIntervalTimeType(data, start) == ATypeTag.DATETIME.serialize()) {
            return 8;
        }
        return 4;
    }

    public static long getIntervalEnd(byte[] data, int start) {
        if (AIntervalSerializerDeserializer.getIntervalTimeType(data, start) == ATypeTag.DATETIME.serialize()) {
            return LongPointable.getLong((byte[])data, (int)AIntervalSerializerDeserializer.getIntervalEndOffset(data, start));
        }
        return IntegerPointable.getInteger((byte[])data, (int)AIntervalSerializerDeserializer.getIntervalEndOffset(data, start));
    }

    public static int getIntervalEndOffset(byte[] data, int start) {
        return AIntervalSerializerDeserializer.getIntervalStartOffset(start) + AIntervalSerializerDeserializer.getStartSize(data, start);
    }

    public static int getEndSize(byte[] data, int start) {
        if (AIntervalSerializerDeserializer.getIntervalTimeType(data, start) == ATypeTag.DATETIME.serialize()) {
            return 8;
        }
        return 4;
    }

    public static int getIntervalLength(byte[] data, int start) {
        return AIntervalSerializerDeserializer.getTypeSize() + AIntervalSerializerDeserializer.getStartSize(data, start) + AIntervalSerializerDeserializer.getEndSize(data, start);
    }
}

