/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.ipc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import org.apache.asterix.external.ipc.ExternalFunctionResultRouter;
import org.apache.asterix.external.ipc.MessageType;
import org.apache.asterix.external.library.msgpack.MessagePackerFromADM;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.util.JavaSerializationUtils;

public class PythonMessageBuilder {
    private static final int MAX_BUF_SIZE = 0x4000000;
    MessageType type = null;
    long dataLength = -1L;
    ByteBuffer buf = ByteBuffer.allocate(4096);

    public void setType(MessageType type) {
        this.type = type;
    }

    public void packHeader() throws HyracksDataException {
        MessagePackerFromADM.packFixPos(this.buf, (byte)this.type.ordinal());
    }

    private static int getStringLength(String s) {
        return s.length();
    }

    public void readHead(ByteBuffer buf) {
        byte typ = buf.get();
        this.type = MessageType.fromByte(typ);
    }

    public void hello() throws IOException {
        this.type = MessageType.HELO;
        byte[] serAddr = this.serialize(new InetSocketAddress(InetAddress.getLoopbackAddress(), 1));
        this.dataLength = serAddr.length + 1;
        this.packHeader();
        this.buf.put((byte)-58);
        this.buf.putInt(serAddr.length);
        this.buf.put(serAddr);
    }

    public void quit() throws HyracksDataException {
        this.type = MessageType.QUIT;
        this.dataLength = PythonMessageBuilder.getStringLength("QUIT");
        this.packHeader();
        MessagePackerFromADM.packFixStr(this.buf, "QUIT");
    }

    public void init(String module, String clazz, String fn) throws HyracksDataException {
        this.type = MessageType.INIT;
        this.dataLength = clazz != null ? (long)(PythonMessageBuilder.getStringLength(module) + PythonMessageBuilder.getStringLength(clazz) + PythonMessageBuilder.getStringLength(fn) + 2) : (long)(PythonMessageBuilder.getStringLength(module) + PythonMessageBuilder.getStringLength(fn) + 2);
        this.packHeader();
        int numArgs = clazz == null ? 2 : 3;
        MessagePackerFromADM.packFixArrayHeader(this.buf, (byte)numArgs);
        MessagePackerFromADM.packStr(this.buf, module);
        if (clazz != null) {
            MessagePackerFromADM.packStr(this.buf, clazz);
        }
        MessagePackerFromADM.packStr(this.buf, fn);
    }

    public void call(byte[] args, int lim, int numArgs) throws HyracksDataException {
        if (args.length > this.buf.capacity()) {
            int growTo = ExternalFunctionResultRouter.closestPow2((int)args.length);
            if (growTo > 0x4000000) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Unable to allocate message buffer larger than:67108864 bytes"});
            }
            this.buf = ByteBuffer.allocate(growTo);
        }
        this.buf.clear();
        this.buf.position(0);
        this.type = MessageType.CALL;
        this.dataLength = 6 + lim;
        this.packHeader();
        this.buf.put((byte)-111);
        this.buf.put((byte)-35);
        this.buf.putInt(numArgs);
        if (numArgs > 0) {
            this.buf.put(args, 0, lim);
        }
    }

    public void callMulti(byte[] args, int lim, int numArgs) throws HyracksDataException {
        if (args.length > this.buf.capacity()) {
            int growTo = ExternalFunctionResultRouter.closestPow2((int)args.length);
            if (growTo > 0x4000000) {
                throw HyracksDataException.create((ErrorCode)ErrorCode.ILLEGAL_STATE, (Serializable[])new Serializable[]{"Unable to allocate message buffer larger than:67108864 bytes"});
            }
            this.buf = ByteBuffer.allocate(growTo);
        }
        this.buf.clear();
        this.buf.position(0);
        this.type = MessageType.CALL;
        this.dataLength = 6 + lim;
        this.packHeader();
        this.buf.put((byte)-36);
        this.buf.putShort((short)numArgs);
        if (numArgs > 0) {
            this.buf.put(args, 0, lim);
        }
    }

    private byte[] serialize(Object object) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (ObjectOutputStream oos = JavaSerializationUtils.getSerializationProvider().newObjectOutputStream((OutputStream)baos);){
            oos.writeObject(object);
            oos.flush();
            baos.close();
        }
        return baos.toByteArray();
    }
}

