/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules.am;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.common.config.DatasetConfig;
import org.apache.asterix.common.metadata.DataverseName;
import org.apache.asterix.optimizer.rules.am.AccessMethodJobGenParams;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;

public class BTreeJobGenParams
extends AccessMethodJobGenParams {
    protected List<LogicalVariable> lowKeyVarList;
    protected List<LogicalVariable> highKeyVarList;
    protected boolean lowKeyInclusive;
    protected boolean highKeyInclusive;
    protected boolean isEqCondition;

    public BTreeJobGenParams() {
    }

    public BTreeJobGenParams(String indexName, DatasetConfig.IndexType indexType, DataverseName dataverseName, String datasetName, boolean retainInput, boolean requiresBroadcast) {
        super(indexName, indexType, dataverseName, datasetName, retainInput, requiresBroadcast);
    }

    public void setLowKeyVarList(List<LogicalVariable> keyVarList, int startIndex, int numKeys) {
        this.lowKeyVarList = new ArrayList<LogicalVariable>(numKeys);
        this.setKeyVarList(keyVarList, this.lowKeyVarList, startIndex, numKeys);
    }

    public void setHighKeyVarList(List<LogicalVariable> keyVarList, int startIndex, int numKeys) {
        this.highKeyVarList = new ArrayList<LogicalVariable>(numKeys);
        this.setKeyVarList(keyVarList, this.highKeyVarList, startIndex, numKeys);
    }

    private void setKeyVarList(List<LogicalVariable> src, List<LogicalVariable> dest, int startIndex, int numKeys) {
        for (int i = 0; i < numKeys; ++i) {
            dest.add(src.get(startIndex + i));
        }
    }

    public void setLowKeyInclusive(boolean lowKeyInclusive) {
        this.lowKeyInclusive = lowKeyInclusive;
    }

    public void setHighKeyInclusive(boolean highKeyInclusive) {
        this.highKeyInclusive = highKeyInclusive;
    }

    public void setIsEqCondition(boolean isEqConsition) {
        this.isEqCondition = isEqConsition;
    }

    @Override
    public void writeToFuncArgs(List<Mutable<ILogicalExpression>> funcArgs) {
        super.writeToFuncArgs(funcArgs);
        this.writeVarList(this.lowKeyVarList, funcArgs);
        this.writeVarList(this.highKeyVarList, funcArgs);
        this.writeBoolean(this.lowKeyInclusive, funcArgs);
        this.writeBoolean(this.highKeyInclusive, funcArgs);
        this.writeBoolean(this.isEqCondition, funcArgs);
    }

    @Override
    public void readFromFuncArgs(List<Mutable<ILogicalExpression>> funcArgs) throws AlgebricksException {
        super.readFromFuncArgs(funcArgs);
        int index = super.getNumParams();
        this.lowKeyVarList = new ArrayList<LogicalVariable>();
        this.highKeyVarList = new ArrayList<LogicalVariable>();
        int nextIndex = this.readVarList(funcArgs, index, this.lowKeyVarList);
        nextIndex = this.readVarList(funcArgs, nextIndex, this.highKeyVarList);
        nextIndex = this.readKeyInclusives(funcArgs, nextIndex);
        this.readIsEqCondition(funcArgs, nextIndex);
    }

    private int readKeyInclusives(List<Mutable<ILogicalExpression>> funcArgs, int index) {
        this.lowKeyInclusive = ((ConstantExpression)funcArgs.get(index).getValue()).getValue().isTrue();
        this.highKeyInclusive = ((ConstantExpression)funcArgs.get(index + 1).getValue()).getValue().isTrue();
        return index + 2;
    }

    private void readIsEqCondition(List<Mutable<ILogicalExpression>> funcArgs, int index) {
        this.isEqCondition = ((ConstantExpression)funcArgs.get(index).getValue()).getValue().isTrue();
    }

    private void writeBoolean(boolean val, List<Mutable<ILogicalExpression>> funcArgs) {
        ConstantExpression keyExpr = val ? ConstantExpression.TRUE : ConstantExpression.FALSE;
        funcArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)keyExpr));
    }

    public List<LogicalVariable> getLowKeyVarList() {
        return this.lowKeyVarList;
    }

    public List<LogicalVariable> getHighKeyVarList() {
        return this.highKeyVarList;
    }

    public boolean isEqCondition() {
        return this.isEqCondition;
    }

    public boolean isLowKeyInclusive() {
        return this.lowKeyInclusive;
    }

    public boolean isHighKeyInclusive() {
        return this.highKeyInclusive;
    }
}

