/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.annotation.HeaderCollection;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.DateTimeRfc1123;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.LeaseDurationType;
import com.azure.storage.blob.models.LeaseStateType;
import com.azure.storage.blob.models.LeaseStatusType;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlRootElement;
import java.time.OffsetDateTime;
import java.util.Map;

@JacksonXmlRootElement(localName="Blob-Download-Headers")
public final class BlobDownloadHeaders {
    @JsonProperty(value="Last-Modified")
    private DateTimeRfc1123 lastModified;
    @HeaderCollection(value="x-ms-meta-")
    private Map<String, String> metadata;
    @JsonProperty(value="Content-Length")
    private Long contentLength;
    @JsonProperty(value="Content-Type")
    private String contentType;
    @JsonProperty(value="Content-Range")
    private String contentRange;
    @JsonProperty(value="ETag")
    private String eTag;
    @JsonProperty(value="Content-MD5")
    private byte[] contentMd5;
    @JsonProperty(value="Content-Encoding")
    private String contentEncoding;
    @JsonProperty(value="Cache-Control")
    private String cacheControl;
    @JsonProperty(value="Content-Disposition")
    private String contentDisposition;
    @JsonProperty(value="Content-Language")
    private String contentLanguage;
    @JsonProperty(value="x-ms-blob-sequence-number")
    private Long blobSequenceNumber;
    @JsonProperty(value="x-ms-blob-type")
    private BlobType blobType;
    @JsonProperty(value="x-ms-copy-completion-time")
    private DateTimeRfc1123 copyCompletionTime;
    @JsonProperty(value="x-ms-copy-status-description")
    private String copyStatusDescription;
    @JsonProperty(value="x-ms-copy-id")
    private String copyId;
    @JsonProperty(value="x-ms-copy-progress")
    private String copyProgress;
    @JsonProperty(value="x-ms-copy-source")
    private String copySource;
    @JsonProperty(value="x-ms-copy-status")
    private CopyStatusType copyStatus;
    @JsonProperty(value="x-ms-lease-duration")
    private LeaseDurationType leaseDuration;
    @JsonProperty(value="x-ms-lease-state")
    private LeaseStateType leaseState;
    @JsonProperty(value="x-ms-lease-status")
    private LeaseStatusType leaseStatus;
    @JsonProperty(value="x-ms-client-request-id")
    private String clientRequestId;
    @JsonProperty(value="x-ms-request-id")
    private String requestId;
    @JsonProperty(value="x-ms-version")
    private String version;
    @JsonProperty(value="Accept-Ranges")
    private String acceptRanges;
    @JsonProperty(value="Date")
    private DateTimeRfc1123 dateProperty;
    @JsonProperty(value="x-ms-blob-committed-block-count")
    private Integer blobCommittedBlockCount;
    @JsonProperty(value="x-ms-server-encrypted")
    private Boolean isServerEncrypted;
    @JsonProperty(value="x-ms-encryption-key-sha256")
    private String encryptionKeySha256;
    @JsonProperty(value="x-ms-encryption-scope")
    private String encryptionScope;
    @JsonProperty(value="x-ms-blob-content-md5")
    private byte[] blobContentMD5;
    @JsonProperty(value="x-ms-content-crc64")
    private byte[] contentCrc64;
    @JsonProperty(value="x-ms-error-code")
    private String errorCode;

    public OffsetDateTime getLastModified() {
        if (this.lastModified == null) {
            return null;
        }
        return this.lastModified.getDateTime();
    }

    public BlobDownloadHeaders setLastModified(OffsetDateTime lastModified) {
        this.lastModified = lastModified == null ? null : new DateTimeRfc1123(lastModified);
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public BlobDownloadHeaders setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Long getContentLength() {
        return this.contentLength;
    }

    public BlobDownloadHeaders setContentLength(Long contentLength) {
        this.contentLength = contentLength;
        return this;
    }

    public String getContentType() {
        return this.contentType;
    }

    public BlobDownloadHeaders setContentType(String contentType) {
        this.contentType = contentType;
        return this;
    }

    public String getContentRange() {
        return this.contentRange;
    }

    public BlobDownloadHeaders setContentRange(String contentRange) {
        this.contentRange = contentRange;
        return this;
    }

    public String getETag() {
        return this.eTag;
    }

    public BlobDownloadHeaders setETag(String eTag) {
        this.eTag = eTag;
        return this;
    }

    public byte[] getContentMd5() {
        return CoreUtils.clone((byte[])this.contentMd5);
    }

    public BlobDownloadHeaders setContentMd5(byte[] contentMd5) {
        this.contentMd5 = CoreUtils.clone((byte[])contentMd5);
        return this;
    }

    public String getContentEncoding() {
        return this.contentEncoding;
    }

    public BlobDownloadHeaders setContentEncoding(String contentEncoding) {
        this.contentEncoding = contentEncoding;
        return this;
    }

    public String getCacheControl() {
        return this.cacheControl;
    }

    public BlobDownloadHeaders setCacheControl(String cacheControl) {
        this.cacheControl = cacheControl;
        return this;
    }

    public String getContentDisposition() {
        return this.contentDisposition;
    }

    public BlobDownloadHeaders setContentDisposition(String contentDisposition) {
        this.contentDisposition = contentDisposition;
        return this;
    }

    public String getContentLanguage() {
        return this.contentLanguage;
    }

    public BlobDownloadHeaders setContentLanguage(String contentLanguage) {
        this.contentLanguage = contentLanguage;
        return this;
    }

    public Long getBlobSequenceNumber() {
        return this.blobSequenceNumber;
    }

    public BlobDownloadHeaders setBlobSequenceNumber(Long blobSequenceNumber) {
        this.blobSequenceNumber = blobSequenceNumber;
        return this;
    }

    public BlobType getBlobType() {
        return this.blobType;
    }

    public BlobDownloadHeaders setBlobType(BlobType blobType) {
        this.blobType = blobType;
        return this;
    }

    public OffsetDateTime getCopyCompletionTime() {
        if (this.copyCompletionTime == null) {
            return null;
        }
        return this.copyCompletionTime.getDateTime();
    }

    public BlobDownloadHeaders setCopyCompletionTime(OffsetDateTime copyCompletionTime) {
        this.copyCompletionTime = copyCompletionTime == null ? null : new DateTimeRfc1123(copyCompletionTime);
        return this;
    }

    public String getCopyStatusDescription() {
        return this.copyStatusDescription;
    }

    public BlobDownloadHeaders setCopyStatusDescription(String copyStatusDescription) {
        this.copyStatusDescription = copyStatusDescription;
        return this;
    }

    public String getCopyId() {
        return this.copyId;
    }

    public BlobDownloadHeaders setCopyId(String copyId) {
        this.copyId = copyId;
        return this;
    }

    public String getCopyProgress() {
        return this.copyProgress;
    }

    public BlobDownloadHeaders setCopyProgress(String copyProgress) {
        this.copyProgress = copyProgress;
        return this;
    }

    public String getCopySource() {
        return this.copySource;
    }

    public BlobDownloadHeaders setCopySource(String copySource) {
        this.copySource = copySource;
        return this;
    }

    public CopyStatusType getCopyStatus() {
        return this.copyStatus;
    }

    public BlobDownloadHeaders setCopyStatus(CopyStatusType copyStatus) {
        this.copyStatus = copyStatus;
        return this;
    }

    public LeaseDurationType getLeaseDuration() {
        return this.leaseDuration;
    }

    public BlobDownloadHeaders setLeaseDuration(LeaseDurationType leaseDuration) {
        this.leaseDuration = leaseDuration;
        return this;
    }

    public LeaseStateType getLeaseState() {
        return this.leaseState;
    }

    public BlobDownloadHeaders setLeaseState(LeaseStateType leaseState) {
        this.leaseState = leaseState;
        return this;
    }

    public LeaseStatusType getLeaseStatus() {
        return this.leaseStatus;
    }

    public BlobDownloadHeaders setLeaseStatus(LeaseStatusType leaseStatus) {
        this.leaseStatus = leaseStatus;
        return this;
    }

    public String getClientRequestId() {
        return this.clientRequestId;
    }

    public BlobDownloadHeaders setClientRequestId(String clientRequestId) {
        this.clientRequestId = clientRequestId;
        return this;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public BlobDownloadHeaders setRequestId(String requestId) {
        this.requestId = requestId;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public BlobDownloadHeaders setVersion(String version) {
        this.version = version;
        return this;
    }

    public String getAcceptRanges() {
        return this.acceptRanges;
    }

    public BlobDownloadHeaders setAcceptRanges(String acceptRanges) {
        this.acceptRanges = acceptRanges;
        return this;
    }

    public OffsetDateTime getDateProperty() {
        if (this.dateProperty == null) {
            return null;
        }
        return this.dateProperty.getDateTime();
    }

    public BlobDownloadHeaders setDateProperty(OffsetDateTime dateProperty) {
        this.dateProperty = dateProperty == null ? null : new DateTimeRfc1123(dateProperty);
        return this;
    }

    public Integer getBlobCommittedBlockCount() {
        return this.blobCommittedBlockCount;
    }

    public BlobDownloadHeaders setBlobCommittedBlockCount(Integer blobCommittedBlockCount) {
        this.blobCommittedBlockCount = blobCommittedBlockCount;
        return this;
    }

    public Boolean isServerEncrypted() {
        return this.isServerEncrypted;
    }

    public BlobDownloadHeaders setIsServerEncrypted(Boolean isServerEncrypted) {
        this.isServerEncrypted = isServerEncrypted;
        return this;
    }

    public String getEncryptionKeySha256() {
        return this.encryptionKeySha256;
    }

    public BlobDownloadHeaders setEncryptionKeySha256(String encryptionKeySha256) {
        this.encryptionKeySha256 = encryptionKeySha256;
        return this;
    }

    public String getEncryptionScope() {
        return this.encryptionScope;
    }

    public BlobDownloadHeaders setEncryptionScope(String encryptionScope) {
        this.encryptionScope = encryptionScope;
        return this;
    }

    public byte[] getBlobContentMD5() {
        return CoreUtils.clone((byte[])this.blobContentMD5);
    }

    public BlobDownloadHeaders setBlobContentMD5(byte[] blobContentMD5) {
        this.blobContentMD5 = CoreUtils.clone((byte[])blobContentMD5);
        return this;
    }

    public byte[] getContentCrc64() {
        return CoreUtils.clone((byte[])this.contentCrc64);
    }

    public BlobDownloadHeaders setContentCrc64(byte[] contentCrc64) {
        this.contentCrc64 = CoreUtils.clone((byte[])contentCrc64);
        return this;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public BlobDownloadHeaders setErrorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }
}

