/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.util;

import java.io.IOException;
import java.io.Writer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.appender.WriterAppender;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.LoggerConfig;

public class Log4j2Monitor {
    private static final List<String> logs = new ArrayList<String>();

    private Log4j2Monitor() {
    }

    public static void start() {
        LoggerContext context = LoggerContext.getContext((boolean)false);
        WriterAppender appender = WriterAppender.createAppender(null, null, (Writer)new LogWriter(), (String)"MEMORY", (boolean)false, (boolean)true);
        appender.start();
        Configuration config = context.getConfiguration();
        config.addAppender((Appender)appender);
        for (LoggerConfig loggerConfig : config.getLoggers().values()) {
            loggerConfig.addAppender((Appender)appender, null, null);
        }
        config.getRootLogger().addAppender((Appender)appender, Level.ALL, null);
        context.updateLoggers();
    }

    public static long count(String message) {
        return logs.stream().filter(log -> log.contains(message)).count();
    }

    public static void reset() {
        logs.clear();
    }

    public static List<String> getLogs() {
        return logs;
    }

    private static class LogWriter
    extends Writer {
        private LogWriter() {
        }

        @Override
        public void write(char[] buffer, int off, int len) {
            logs.add(CharBuffer.wrap(buffer, off, len).toString());
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() throws IOException {
        }
    }
}

