/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.cost;

import org.apache.asterix.optimizer.cost.ICost;

public class Cost
implements ICost {
    public static final double MAX_CARD = 1.0E200;
    protected static final int COST_EQ = 0;
    private final double cost;

    public Cost() {
        this.cost = 0.0;
    }

    public Cost(double cost) {
        this.cost = cost;
    }

    @Override
    public ICost zeroCost() {
        return new Cost();
    }

    @Override
    public ICost maxCost() {
        return new Cost(1.0E200);
    }

    @Override
    public ICost costAdd(ICost cost) {
        return new Cost(this.computeTotalCost() + cost.computeTotalCost());
    }

    @Override
    public boolean costEQ(ICost cost) {
        return this.compareTo(cost) == 0;
    }

    @Override
    public boolean costLT(ICost cost) {
        return this.compareTo(cost) < 0;
    }

    @Override
    public boolean costGT(ICost cost) {
        return this.compareTo(cost) > 0;
    }

    @Override
    public boolean costLE(ICost cost) {
        return this.compareTo(cost) <= 0;
    }

    @Override
    public boolean costGE(ICost cost) {
        return this.compareTo(cost) >= 0;
    }

    @Override
    public double computeTotalCost() {
        return this.cost;
    }

    @Override
    public int compareTo(ICost cost) {
        return Double.compare(this.computeTotalCost(), cost.computeTotalCost());
    }

    public String toString() {
        return Double.toString(this.cost);
    }
}

