/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.lang.sqlpp.util.SqlppVariableUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.AggregateFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.VariableReferenceExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AggregateOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AssignOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.GroupByOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.visitors.VariableUtilities;
import org.apache.hyracks.algebricks.core.algebra.util.OperatorManipulationUtil;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;

public class PushAggFuncIntoStandaloneAggregateRule
implements IAlgebraicRewriteRule {
    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }

    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() != LogicalOperatorTag.ASSIGN) {
            return false;
        }
        AssignOperator assignOp = (AssignOperator)op;
        Mutable opRef2 = (Mutable)op.getInputs().get(0);
        AbstractLogicalOperator op2 = (AbstractLogicalOperator)opRef2.getValue();
        if (op2.getOperatorTag() == LogicalOperatorTag.AGGREGATE) {
            AggregateOperator aggOp = (AggregateOperator)op2;
            return this.pushAggregateFunction(assignOp, aggOp, context);
        }
        if (op2.getOperatorTag() == LogicalOperatorTag.INNERJOIN || op2.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN) {
            AbstractBinaryJoinOperator join = (AbstractBinaryJoinOperator)op2;
            if (this.containsAggregate(assignOp.getExpressions()) && this.pushableThroughJoin(join)) {
                return this.pushAggregateFunctionThroughJoin(assignOp, join, context);
            }
        }
        return false;
    }

    private boolean containsAggregate(List<Mutable<ILogicalExpression>> exprRefs) {
        for (Mutable<ILogicalExpression> exprRef : exprRefs) {
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
            FunctionIdentifier funcIdent = BuiltinFunctions.getAggregateFunction((FunctionIdentifier)funcExpr.getFunctionIdentifier());
            if (funcIdent == null) {
                if (!this.containsAggregate(funcExpr.getArguments())) continue;
                return true;
            }
            return true;
        }
        return false;
    }

    private boolean pushableThroughJoin(AbstractBinaryJoinOperator join) {
        ILogicalExpression condition = (ILogicalExpression)join.getCondition().getValue();
        if (condition.equals(ConstantExpression.TRUE)) {
            boolean pushable = true;
            for (Mutable branchRef : join.getInputs()) {
                AbstractLogicalOperator branch = (AbstractLogicalOperator)branchRef.getValue();
                if (branch.getOperatorTag() == LogicalOperatorTag.AGGREGATE) {
                    pushable &= true;
                    continue;
                }
                if (branch.getOperatorTag() == LogicalOperatorTag.INNERJOIN || branch.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN) {
                    AbstractBinaryJoinOperator childJoin = (AbstractBinaryJoinOperator)branch;
                    pushable &= this.pushableThroughJoin(childJoin);
                    continue;
                }
                pushable &= false;
            }
            return pushable;
        }
        return false;
    }

    private boolean pushAggregateFunctionThroughJoin(AssignOperator assignOp, AbstractBinaryJoinOperator join, IOptimizationContext context) throws AlgebricksException {
        boolean applied = false;
        for (Mutable branchRef : join.getInputs()) {
            AbstractLogicalOperator branch = (AbstractLogicalOperator)branchRef.getValue();
            if (branch.getOperatorTag() == LogicalOperatorTag.AGGREGATE) {
                AggregateOperator aggOp = (AggregateOperator)branch;
                applied |= this.pushAggregateFunction(assignOp, aggOp, context);
                continue;
            }
            if (branch.getOperatorTag() != LogicalOperatorTag.INNERJOIN && branch.getOperatorTag() != LogicalOperatorTag.LEFTOUTERJOIN) continue;
            AbstractBinaryJoinOperator childJoin = (AbstractBinaryJoinOperator)branch;
            applied |= this.pushAggregateFunctionThroughJoin(assignOp, childJoin, context);
        }
        return applied;
    }

    private boolean pushAggregateFunction(AssignOperator assignOp, AggregateOperator aggOp, IOptimizationContext context) throws AlgebricksException {
        Mutable aggChilldOpRef = (Mutable)aggOp.getInputs().get(0);
        AbstractLogicalOperator aggChildOp = (AbstractLogicalOperator)aggChilldOpRef.getValue();
        if (aggChildOp.getOperatorTag() == LogicalOperatorTag.GROUP && !((GroupByOperator)aggChildOp).getNestedPlans().isEmpty()) {
            return false;
        }
        ArrayList assignUsedVars = new ArrayList();
        VariableUtilities.getUsedVariables((ILogicalOperator)assignOp, assignUsedVars);
        ArrayList<Mutable<ILogicalExpression>> assignScalarAggExprRefs = new ArrayList<Mutable<ILogicalExpression>>();
        ArrayList<LogicalVariable> aggAddVars = null;
        ArrayList<MutableObject> aggAddExprs = null;
        int n = aggOp.getVariables().size();
        for (int i = 0; i < n; ++i) {
            AbstractFunctionCallExpression listifyCandidateExpr;
            LogicalVariable aggVar = (LogicalVariable)aggOp.getVariables().get(i);
            Mutable aggExprRef = (Mutable)aggOp.getExpressions().get(i);
            ILogicalExpression aggExpr = (ILogicalExpression)aggExprRef.getValue();
            if (aggExpr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL || (listifyCandidateExpr = (AbstractFunctionCallExpression)aggExpr).getFunctionIdentifier() != BuiltinFunctions.LISTIFY || !assignUsedVars.contains(aggVar)) continue;
            assignScalarAggExprRefs.clear();
            this.findScalarAggFuncExprRef(assignOp.getExpressions(), aggVar, assignScalarAggExprRefs);
            if (assignScalarAggExprRefs.isEmpty()) continue;
            if (aggAddVars == null) {
                aggAddVars = new ArrayList<LogicalVariable>();
                aggAddExprs = new ArrayList<MutableObject>();
            }
            for (Mutable mutable : assignScalarAggExprRefs) {
                AbstractFunctionCallExpression assignScalarAggExpr = (AbstractFunctionCallExpression)mutable.getValue();
                FunctionIdentifier aggFuncIdent = BuiltinFunctions.getAggregateFunction((FunctionIdentifier)assignScalarAggExpr.getFunctionIdentifier());
                int nArgs = assignScalarAggExpr.getArguments().size();
                ArrayList<MutableObject> aggArgs = new ArrayList<MutableObject>(nArgs);
                aggArgs.add(new MutableObject((Object)((ILogicalExpression)((Mutable)listifyCandidateExpr.getArguments().get(0)).getValue()).cloneExpression()));
                aggArgs.addAll(OperatorManipulationUtil.cloneExpressions(assignScalarAggExpr.getArguments().subList(1, nArgs)));
                AggregateFunctionCallExpression aggFuncExpr = BuiltinFunctions.makeAggregateFunctionExpression((FunctionIdentifier)aggFuncIdent, aggArgs);
                aggFuncExpr.setSourceLocation(assignScalarAggExpr.getSourceLocation());
                LogicalVariable newVar = context.newVar();
                aggAddVars.add(newVar);
                aggAddExprs.add(new MutableObject((Object)aggFuncExpr));
                VariableReferenceExpression newVarRef = new VariableReferenceExpression(newVar);
                newVarRef.setSourceLocation(assignScalarAggExpr.getSourceLocation());
                mutable.setValue((Object)newVarRef);
            }
        }
        if (aggAddVars == null) {
            return false;
        }
        aggOp.getVariables().addAll(aggAddVars);
        aggOp.getExpressions().addAll(aggAddExprs);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)aggOp);
        context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)assignOp);
        return true;
    }

    private void findScalarAggFuncExprRef(List<Mutable<ILogicalExpression>> exprRefs, LogicalVariable aggVar, List<Mutable<ILogicalExpression>> outScalarAggExprRefs) {
        for (Mutable<ILogicalExpression> exprRef : exprRefs) {
            ILogicalExpression expr = (ILogicalExpression)exprRef.getValue();
            if (expr.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) continue;
            AbstractFunctionCallExpression funcExpr = (AbstractFunctionCallExpression)expr;
            FunctionIdentifier funcIdent = BuiltinFunctions.getAggregateFunction((FunctionIdentifier)funcExpr.getFunctionIdentifier());
            if (funcIdent != null && aggVar.equals((Object)SqlppVariableUtil.getVariable((ILogicalExpression)((ILogicalExpression)((Mutable)funcExpr.getArguments().get(0)).getValue())))) {
                outScalarAggExprRefs.add(exprRef);
                continue;
            }
            this.findScalarAggFuncExprRef(funcExpr.getArguments(), aggVar, outScalarAggExprRefs);
        }
    }
}

