/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.btree.impls;

import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.api.IBTreeFrame;
import org.apache.hyracks.storage.am.btree.api.IBTreeLeafFrame;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BTreeOpContext;
import org.apache.hyracks.storage.am.btree.impls.BTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.DiskBTreePointSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.DiskBTreeRangeSearchCursor;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.IPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrameFactory;
import org.apache.hyracks.storage.am.common.impls.TreeIndexDiskOrderScanCursor;
import org.apache.hyracks.storage.am.common.ophelpers.IndexOperation;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessParameters;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.MultiComparator;
import org.apache.hyracks.storage.common.NoOpIndexCursorStats;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;

public class DiskBTree
extends BTree {
    public DiskBTree(IBufferCache bufferCache, IPageManager freePageManager, ITreeIndexFrameFactory interiorFrameFactory, ITreeIndexFrameFactory leafFrameFactory, IBinaryComparatorFactory[] cmpFactories, int fieldCount, FileReference file) {
        super(bufferCache, freePageManager, interiorFrameFactory, leafFrameFactory, cmpFactories, fieldCount, file);
    }

    private void diskOrderScan(ITreeIndexCursor icursor, BTreeOpContext ctx) throws HyracksDataException {
        TreeIndexDiskOrderScanCursor cursor = (TreeIndexDiskOrderScanCursor)icursor;
        ctx.reset();
        RangePredicate diskOrderScanPred = new RangePredicate(null, null, true, true, ctx.getCmp(), ctx.getCmp());
        int maxPageId = this.freePageManager.getMaxPageId(ctx.getMetaFrame());
        int currentPageId = this.bulkloadLeafStart;
        ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)currentPageId), false);
        try {
            cursor.setBufferCache(this.bufferCache);
            cursor.setFileId(this.getFileId());
            cursor.setCurrentPageId(currentPageId);
            cursor.setMaxPageId(maxPageId);
            ctx.getCursorInitialState().setPage(page);
            ctx.getCursorInitialState().setSearchOperationCallback(ctx.getSearchCallback());
            ctx.getCursorInitialState().setOriginialKeyComparator(ctx.getCmp());
            cursor.open((ICursorInitialState)ctx.getCursorInitialState(), (ISearchPredicate)diskOrderScanPred);
        }
        catch (Exception e) {
            this.bufferCache.unpin(page);
            throw HyracksDataException.create((Throwable)e);
        }
    }

    private void search(ITreeIndexCursor cursor, ISearchPredicate searchPred, BTreeOpContext ctx) throws HyracksDataException {
        DiskBTreePointSearchCursor pointCursor;
        int lastPageId;
        ctx.reset();
        ctx.setPred((RangePredicate)searchPred);
        ctx.setCursor(cursor);
        if (ctx.getPred().getLowKeyComparator() == null) {
            ctx.getPred().setLowKeyComparator(ctx.getCmp());
        }
        if (ctx.getPred().getHighKeyComparator() == null) {
            ctx.getPred().setHighKeyComparator(ctx.getCmp());
        }
        cursor.setBufferCache(this.bufferCache);
        cursor.setFileId(this.getFileId());
        if (cursor instanceof DiskBTreePointSearchCursor && (lastPageId = (pointCursor = (DiskBTreePointSearchCursor)cursor).getLastPageId()) != -1) {
            ICachedPage lastPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)lastPageId), false);
            ctx.getLeafFrame().setPage(lastPage);
            if (this.fitInPage(ctx.getPred().getLowKey(), ctx.getPred().getLowKeyComparator(), ctx.getLeafFrame())) {
                ctx.getCursorInitialState().setPage(lastPage);
                ctx.getCursorInitialState().setPageId(lastPageId);
                pointCursor.open(ctx.getCursorInitialState(), searchPred);
                return;
            }
            this.bufferCache.unpin(lastPage);
            pointCursor.clearSearchState();
        }
        ICachedPage rootNode = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)this.rootPage), false);
        this.searchDown(rootNode, this.rootPage, ctx, cursor);
    }

    private boolean fitInPage(ITupleReference key, MultiComparator comparator, IBTreeFrame frame) throws HyracksDataException {
        ITupleReference rightmostTuple = frame.getRightmostTuple();
        int cmp = comparator.compare(key, rightmostTuple);
        return cmp <= 0;
    }

    private void searchDown(ICachedPage page, int pageId, BTreeOpContext ctx, ITreeIndexCursor cursor) throws HyracksDataException {
        ICachedPage currentPage = page;
        ctx.getInteriorFrame().setPage(currentPage);
        try {
            int childPageId = pageId;
            while (!ctx.getInteriorFrame().isLeaf()) {
                childPageId = ctx.getInteriorFrame().getChildPageId(ctx.getPred());
                this.bufferCache.unpin(currentPage);
                pageId = childPageId;
                currentPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.getFileId(), (int)childPageId), false);
                ctx.getInteriorFrame().setPage(currentPage);
            }
            ctx.getCursorInitialState().setSearchOperationCallback(ctx.getSearchCallback());
            ctx.getCursorInitialState().setOriginialKeyComparator(ctx.getCmp());
            ctx.getCursorInitialState().setPage(currentPage);
            ctx.getCursorInitialState().setPageId(childPageId);
            ctx.getLeafFrame().setPage(currentPage);
            cursor.open((ICursorInitialState)ctx.getCursorInitialState(), (ISearchPredicate)ctx.getPred());
        }
        catch (HyracksDataException e) {
            if (!ctx.isExceptionHandled() && currentPage != null) {
                this.bufferCache.unpin(currentPage);
                ctx.setExceptionHandled(true);
            }
            throw e;
        }
        catch (Exception e) {
            if (currentPage != null) {
                this.bufferCache.unpin(currentPage);
            }
            HyracksDataException wrappedException = HyracksDataException.create((Throwable)e);
            ctx.setExceptionHandled(true);
            throw wrappedException;
        }
    }

    @Override
    public BTree.BTreeAccessor createAccessor(IIndexAccessParameters iap) {
        return new DiskBTreeAccessor(this, iap);
    }

    public class DiskBTreeAccessor
    extends BTree.BTreeAccessor {
        public DiskBTreeAccessor(DiskBTree btree, IIndexAccessParameters iap) {
            super(btree, iap);
        }

        @Override
        public void insert(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Insert is not supported by DiskBTree. ");
        }

        @Override
        public void update(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Update is not supported by DiskBTree. ");
        }

        @Override
        public void delete(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Delete is not supported by DiskBTree. ");
        }

        @Override
        public void upsert(ITupleReference tuple) throws HyracksDataException {
            throw new UnsupportedOperationException("Upsert is not supported by DiskBTree. ");
        }

        @Override
        public DiskBTreeRangeSearchCursor createSearchCursor(boolean exclusive) {
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)this.btree.getLeafFrameFactory().createFrame();
            return new DiskBTreeRangeSearchCursor(leafFrame, exclusive, this.iap.getParameters().getOrDefault("INDEX_CURSOR_STATS", NoOpIndexCursorStats.INSTANCE));
        }

        @Override
        public BTreeRangeSearchCursor createPointCursor(boolean exclusive, boolean stateful) {
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)this.btree.getLeafFrameFactory().createFrame();
            return new DiskBTreePointSearchCursor(leafFrame, exclusive, stateful);
        }

        @Override
        public void search(IIndexCursor cursor, ISearchPredicate searchPred) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.SEARCH);
            ((DiskBTree)this.btree).search((ITreeIndexCursor)cursor, searchPred, this.ctx);
        }

        @Override
        public ITreeIndexCursor createDiskOrderScanCursor() {
            IBTreeLeafFrame leafFrame = (IBTreeLeafFrame)this.btree.getLeafFrameFactory().createFrame();
            return new DiskBTreeDiskScanCursor(leafFrame);
        }

        @Override
        public void diskOrderScan(ITreeIndexCursor cursor) throws HyracksDataException {
            this.ctx.setOperation(IndexOperation.DISKORDERSCAN);
            ((DiskBTree)this.btree).diskOrderScan(cursor, this.ctx);
        }
    }

    private class DiskBTreeDiskScanCursor
    extends TreeIndexDiskOrderScanCursor {
        public DiskBTreeDiskScanCursor(ITreeIndexFrame frame) {
            super(frame);
        }

        protected void releasePage() throws HyracksDataException {
            if (this.page != null) {
                this.bufferCache.unpin(this.page);
                this.page = null;
            }
        }

        protected ICachedPage acquireNextPage() throws HyracksDataException {
            ICachedPage nextPage = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)this.fileId, (int)this.currentPageId), false);
            return nextPage;
        }
    }
}

