/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.dataflow.data.nontagged.printers.json.losslessadm;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.asterix.dataflow.data.nontagged.serde.ADoubleSerializerDeserializer;
import org.apache.asterix.dataflow.data.nontagged.serde.AFloatSerializerDeserializer;
import org.apache.hyracks.algebricks.data.IPrinter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.util.bytes.HexPrinter;

public abstract class ATaggedValuePrinter
implements IPrinter {
    public static final char DELIMITER = ':';

    public void print(byte[] b, int s, int l, PrintStream ps) throws HyracksDataException {
        try {
            ps.print("\"");
            ATaggedValuePrinter.printTypeTag(b, s, ps);
            ATaggedValuePrinter.printDelimiter(ps);
            this.printNonTaggedValue(b, s, l, ps);
            ps.print("\"");
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    static void printTypeTag(byte[] b, int s, PrintStream ps) throws IOException {
        HexPrinter.printHexString((byte[])b, (int)s, (int)1, (Appendable)ps);
    }

    static void printDelimiter(PrintStream ps) {
        ps.print(':');
    }

    static void printFloat(byte[] b, int s, PrintStream ps) {
        int bits = AFloatSerializerDeserializer.getIntBits(b, s);
        ps.print(bits);
    }

    static void printDouble(byte[] b, int s, PrintStream ps) {
        long bits = ADoubleSerializerDeserializer.getLongBits(b, s);
        ps.print(bits);
    }

    protected abstract void printNonTaggedValue(byte[] var1, int var2, int var3, PrintStream var4) throws IOException;
}

