/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.functions;

import org.apache.asterix.common.annotations.MissingNullInOutFunction;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.om.functions.IFunctionDescriptorFactory;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.hierachy.ATypeHierarchy;
import org.apache.asterix.runtime.evaluators.base.AbstractScalarFunctionDynamicDescriptor;
import org.apache.asterix.runtime.evaluators.common.ArgumentUtils;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.asterix.runtime.evaluators.functions.utils.RandomHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluatorFactory;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;

@MissingNullInOutFunction
public class RandomWithSeedDescriptor
extends AbstractScalarFunctionDynamicDescriptor {
    private static final long serialVersionUID = 1L;
    public static final IFunctionDescriptorFactory FACTORY = RandomWithSeedDescriptor::new;

    public IScalarEvaluatorFactory createEvaluatorFactory(final IScalarEvaluatorFactory[] args) {
        return new IScalarEvaluatorFactory(){
            private static final long serialVersionUID = 1L;

            public IScalarEvaluator createScalarEvaluator(final IEvaluatorContext ctx) throws HyracksDataException {
                return new IScalarEvaluator(){
                    private final IScalarEvaluator eval0;
                    private final IPointable arg0;
                    private final RandomHelper randomHelper;
                    {
                        this.eval0 = args[0].createScalarEvaluator(ctx);
                        this.arg0 = new VoidPointable();
                        this.randomHelper = new RandomHelper(true);
                    }

                    public void evaluate(IFrameTupleReference tuple, IPointable resultPointable) throws HyracksDataException {
                        this.eval0.evaluate(tuple, this.arg0);
                        if (PointableHelper.checkAndSetMissingOrNull(resultPointable, this.arg0)) {
                            return;
                        }
                        byte[] bytes = this.arg0.getByteArray();
                        int offset = this.arg0.getStartOffset();
                        ATypeTag tt = ATypeTag.VALUE_TYPE_MAPPING[bytes[offset]];
                        switch (tt) {
                            case TINYINT: 
                            case SMALLINT: 
                            case INTEGER: 
                            case BIGINT: 
                            case FLOAT: 
                            case DOUBLE: {
                                double seed = ATypeHierarchy.getDoubleValue((String)RandomWithSeedDescriptor.this.getIdentifier().getName(), (int)0, (byte[])bytes, (int)offset);
                                this.randomHelper.setSeed(seed);
                                this.randomHelper.nextDouble(resultPointable);
                                break;
                            }
                            default: {
                                ExceptionUtil.warnTypeMismatch((IEvaluatorContext)ctx, (SourceLocation)RandomWithSeedDescriptor.this.sourceLoc, (FunctionIdentifier)RandomWithSeedDescriptor.this.getIdentifier(), (byte)bytes[offset], (int)0, (byte[])ArgumentUtils.NUMERIC_TYPES);
                                PointableHelper.setNull(resultPointable);
                            }
                        }
                    }
                };
            }
        };
    }

    public FunctionIdentifier getIdentifier() {
        return BuiltinFunctions.RANDOM_WITH_SEED;
    }
}

