/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.transaction;

import it.unimi.dsi.fastutil.longs.LongArrayFIFOQueue;
import it.unimi.dsi.fastutil.longs.LongPriorityQueue;
import it.unimi.dsi.fastutil.longs.LongPriorityQueues;
import java.util.NoSuchElementException;
import java.util.concurrent.LinkedBlockingQueue;
import org.apache.asterix.common.messaging.api.ICcAddressedMessage;
import org.apache.asterix.common.messaging.api.INCMessageBroker;
import org.apache.asterix.runtime.message.ResourceIdRequestMessage;
import org.apache.asterix.runtime.message.ResourceIdRequestResponseMessage;
import org.apache.hyracks.api.application.INCServiceContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.common.file.IResourceIdFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class GlobalResourceIdFactory
implements IResourceIdFactory {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int RESOURCE_ID_BLOCK_SIZE = 25;
    private final INCServiceContext serviceCtx;
    private final LongPriorityQueue resourceIds = LongPriorityQueues.synchronize((LongPriorityQueue)new LongArrayFIFOQueue(25));
    private final LinkedBlockingQueue<ResourceIdRequestResponseMessage> resourceIdResponseQ;
    private final String nodeId;

    public GlobalResourceIdFactory(INCServiceContext serviceCtx) {
        this.serviceCtx = serviceCtx;
        this.resourceIdResponseQ = new LinkedBlockingQueue();
        this.nodeId = serviceCtx.getNodeId();
    }

    public void addNewIds(ResourceIdRequestResponseMessage resourceIdResponse) throws InterruptedException {
        LOGGER.debug("rec'd block of ids: {}", (Object)resourceIdResponse);
        this.resourceIdResponseQ.put(resourceIdResponse);
    }

    public long createId() throws HyracksDataException {
        try {
            long resourceId = this.resourceIds.dequeueLong();
            if (this.resourceIds.isEmpty()) {
                this.serviceCtx.getControllerService().getExecutor().submit(() -> {
                    try {
                        this.requestNewBlock();
                    }
                    catch (Exception e) {
                        LOGGER.warn("failed on preemptive block request", (Throwable)e);
                    }
                });
            }
            return resourceId;
        }
        catch (NoSuchElementException resourceId) {
            try {
                ResourceIdRequestResponseMessage response = this.resourceIdResponseQ.poll();
                if (response == null) {
                    this.requestNewBlock();
                    response = this.resourceIdResponseQ.take();
                }
                if (response.getException() != null) {
                    throw HyracksDataException.create((Throwable)response.getException());
                }
                long startingId = response.getResourceId();
                for (int i = 1; i < response.getBlockSize(); ++i) {
                    this.resourceIds.enqueue(startingId + (long)i);
                }
                return startingId;
            }
            catch (Exception e) {
                throw HyracksDataException.create((Throwable)e);
            }
        }
    }

    protected void requestNewBlock() throws Exception {
        ResourceIdRequestMessage msg = new ResourceIdRequestMessage(this.nodeId, 25);
        ((INCMessageBroker)this.serviceCtx.getMessageBroker()).sendMessageToPrimaryCC((ICcAddressedMessage)msg);
    }
}

