/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.common.util;

import java.util.ArrayList;
import java.util.Random;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.FileReference;
import org.apache.hyracks.storage.am.common.api.IMetadataPageManager;
import org.apache.hyracks.storage.am.common.api.ITreeIndexFrame;
import org.apache.hyracks.storage.am.common.api.ITreeIndexMetadataFrame;
import org.apache.hyracks.storage.common.arraylist.IntArrayList;
import org.apache.hyracks.storage.common.buffercache.IBufferCache;
import org.apache.hyracks.storage.common.buffercache.ICachedPage;
import org.apache.hyracks.storage.common.file.BufferedFileHandle;
import org.apache.hyracks.util.MathUtil;

public class TreeIndexBufferCacheWarmup {
    private final IBufferCache bufferCache;
    private final IMetadataPageManager freePageManager;
    private final FileReference fileRef;
    private final ArrayList<IntArrayList> pagesByLevel = new ArrayList();
    private final Random rnd = new Random();

    public TreeIndexBufferCacheWarmup(IBufferCache bufferCache, IMetadataPageManager freePageManager, FileReference fileRef) {
        this.bufferCache = bufferCache;
        this.freePageManager = freePageManager;
        this.fileRef = fileRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void warmup(ITreeIndexFrame frame, ITreeIndexMetadataFrame metaFrame, int[] warmupTreeLevels, int[] warmupRepeats) throws HyracksDataException {
        int fileId = this.bufferCache.openFile(this.fileRef);
        int maxPageId = this.freePageManager.getMaxPageId(metaFrame);
        for (int pageId = 0; pageId <= maxPageId; ++pageId) {
            ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)fileId, (int)pageId), false);
            page.acquireReadLatch();
            try {
                frame.setPage(page);
                byte level = frame.getLevel();
                while (level >= this.pagesByLevel.size()) {
                    this.pagesByLevel.add(new IntArrayList(100, 100));
                }
                if (level < 0) continue;
                this.pagesByLevel.get(level).add(pageId);
                continue;
            }
            finally {
                page.releaseReadLatch();
                this.bufferCache.unpin(page);
            }
        }
        for (int i = 0; i < warmupTreeLevels.length; ++i) {
            if (warmupTreeLevels[i] >= this.pagesByLevel.size()) continue;
            int repeats = warmupRepeats[i];
            IntArrayList pageIds = this.pagesByLevel.get(warmupTreeLevels[i]);
            int[] remainingPageIds = new int[pageIds.size()];
            for (int r = 0; r < repeats; ++r) {
                for (int j = 0; j < pageIds.size(); ++j) {
                    remainingPageIds[j] = pageIds.get(j);
                }
                int remainingLength = pageIds.size();
                for (int j = 0; j < pageIds.size(); ++j) {
                    int index = MathUtil.stripSignBit((int)this.rnd.nextInt()) % remainingLength;
                    int pageId = remainingPageIds[index];
                    ICachedPage page = this.bufferCache.pin(BufferedFileHandle.getDiskPageId((int)fileId, (int)pageId), false);
                    page.acquireReadLatch();
                    page.releaseReadLatch();
                    this.bufferCache.unpin(page);
                    remainingPageIds[index] = remainingPageIds[remainingLength - 1];
                    --remainingLength;
                }
            }
        }
        this.bufferCache.closeFile(fileId);
    }
}

