/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.rtree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.RangePredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexAccessor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;
import org.apache.hyracks.storage.am.lsm.common.impls.LSMIndexSearchCursor;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeCursorInitialState;
import org.apache.hyracks.storage.am.lsm.rtree.impls.LSMRTreeDiskComponent;
import org.apache.hyracks.storage.common.ICursorInitialState;
import org.apache.hyracks.storage.common.IIndexAccessor;
import org.apache.hyracks.storage.common.IIndexCursor;
import org.apache.hyracks.storage.common.IIndexCursorStats;
import org.apache.hyracks.storage.common.ISearchPredicate;
import org.apache.hyracks.storage.common.util.IndexCursorUtils;

public class LSMRTreeDeletedKeysBTreeMergeCursor
extends LSMIndexSearchCursor {
    public LSMRTreeDeletedKeysBTreeMergeCursor(ILSMIndexOperationContext opCtx, IIndexCursorStats stats) {
        super(opCtx, true, stats);
    }

    protected boolean isDeleted(LSMIndexSearchCursor.PriorityQueueElement checkElement) throws HyracksDataException {
        return false;
    }

    public void doOpen(ICursorInitialState initialState, ISearchPredicate searchPred) throws HyracksDataException {
        LSMRTreeCursorInitialState lsmInitialState = (LSMRTreeCursorInitialState)initialState;
        this.cmp = lsmInitialState.getBTreeCmp();
        this.operationalComponents = lsmInitialState.getOperationalComponents();
        this.lsmHarness = null;
        int numBTrees = this.operationalComponents.size();
        this.rangeCursors = new IIndexCursor[numBTrees];
        RangePredicate btreePredicate = new RangePredicate(null, null, true, true, this.cmp, this.cmp);
        ITreeIndexAccessor[] btreeAccessors = new ITreeIndexAccessor[numBTrees];
        for (int i = 0; i < numBTrees; ++i) {
            ILSMComponent component = (ILSMComponent)this.operationalComponents.get(i);
            BTree btree = ((LSMRTreeDiskComponent)component).getBuddyIndex();
            btreeAccessors[i] = btree.createAccessor(this.iap);
            btreeAccessors[i].search(this.rangeCursors[i], (ISearchPredicate)btreePredicate);
            this.rangeCursors[i] = btreeAccessors[i].createSearchCursor(false);
        }
        IndexCursorUtils.open((IIndexAccessor[])btreeAccessors, (IIndexCursor[])this.rangeCursors, (ISearchPredicate)btreePredicate);
        try {
            this.setPriorityQueueComparator();
            this.initPriorityQueue();
        }
        catch (Throwable th) {
            IndexCursorUtils.close((IIndexCursor[])this.rangeCursors, (Throwable)th);
            throw HyracksDataException.create((Throwable)th);
        }
    }
}

