/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.feed.watch;

import java.util.Objects;
import org.apache.asterix.active.IActiveEntityEventSubscriber;
import org.apache.asterix.active.IActiveEntityEventsListener;
import org.apache.hyracks.util.Span;

public abstract class AbstractSubscriber
implements IActiveEntityEventSubscriber {
    protected final IActiveEntityEventsListener listener;
    private final Object lockObject;
    private volatile boolean done = false;
    private volatile Exception failure = null;

    public AbstractSubscriber(IActiveEntityEventsListener listener, Object lockObject) {
        Objects.requireNonNull(lockObject);
        this.listener = listener;
        this.lockObject = lockObject;
    }

    public AbstractSubscriber(IActiveEntityEventsListener listener) {
        this.listener = listener;
        this.lockObject = this;
    }

    public boolean isDone() {
        return this.done;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(Exception failure) {
        Object object = this.lockObject;
        synchronized (object) {
            if (failure != null) {
                this.failure = failure;
            }
            this.done = true;
            this.lockObject.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync() throws InterruptedException {
        Object object = this.lockObject;
        synchronized (object) {
            while (!this.done) {
                this.lockObject.wait();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean sync(Span span) throws InterruptedException {
        Object object = this.lockObject;
        synchronized (object) {
            while (!this.done) {
                span.wait(this.lockObject);
                if (!this.done && !span.elapsed()) continue;
                return this.done;
            }
            return this.done;
        }
    }

    public Exception getFailure() {
        return this.failure;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reset() {
        Object object = this.lockObject;
        synchronized (object) {
            this.done = false;
            this.failure = null;
        }
    }
}

