/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.task;

import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.control.nc.NodeControllerService;
import org.apache.hyracks.util.ThreadDumpUtil;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThreadDumpTask
implements Runnable {
    private static final Logger LOGGER = LogManager.getLogger();
    private final NodeControllerService ncs;
    private final String requestId;
    private final CcId ccId;

    public ThreadDumpTask(NodeControllerService ncs, String requestId, CcId ccId) {
        this.ncs = ncs;
        this.requestId = requestId;
        this.ccId = ccId;
    }

    @Override
    public void run() {
        String result;
        try {
            result = ThreadDumpUtil.takeDumpJSONString();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Exception taking thread dump", (Throwable)e);
            result = null;
        }
        try {
            this.ncs.getClusterController(this.ccId).notifyThreadDump(this.ncs.getContext().getNodeId(), this.requestId, result);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARN, "Exception sending thread dump to CC", (Throwable)e);
        }
    }
}

