/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.replication.messaging;

import java.io.DataInput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collection;
import org.apache.asterix.common.api.INcApplicationContext;
import org.apache.asterix.common.storage.DatasetResourceReference;
import org.apache.asterix.common.storage.IIndexCheckpointManager;
import org.apache.asterix.common.storage.IIndexCheckpointManagerProvider;
import org.apache.asterix.common.storage.ResourceReference;
import org.apache.asterix.common.utils.StoragePathUtil;
import org.apache.asterix.replication.api.IReplicaTask;
import org.apache.asterix.replication.api.IReplicationWorker;
import org.apache.asterix.replication.messaging.ReplicationProtocol;
import org.apache.asterix.transaction.management.resource.PersistentLocalResourceRepository;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.io.IIOManager;
import org.apache.hyracks.storage.am.lsm.common.impls.AbstractLSMIndexFileManager;
import org.apache.hyracks.storage.am.lsm.common.impls.IndexComponentFileReference;
import org.apache.hyracks.storage.common.LocalResource;

public class CheckpointPartitionIndexesTask
implements IReplicaTask {
    private final int partition;
    private final long maxComponentId;
    private final String masterNodeId;

    public CheckpointPartitionIndexesTask(int partition, long maxComponentId, String masterNodeId) {
        this.partition = partition;
        this.maxComponentId = maxComponentId;
        this.masterNodeId = masterNodeId;
    }

    @Override
    public void perform(INcApplicationContext appCtx, IReplicationWorker worker) throws HyracksDataException {
        IIndexCheckpointManagerProvider indexCheckpointManagerProvider = appCtx.getIndexCheckpointManagerProvider();
        PersistentLocalResourceRepository resRepo = (PersistentLocalResourceRepository)appCtx.getLocalResourceRepository();
        IIOManager ioManager = appCtx.getIoManager();
        Collection partitionResources = resRepo.getPartitionResources(this.partition).values();
        long currentLSN = appCtx.getTransactionSubsystem().getLogManager().getAppendLSN();
        for (LocalResource ls : partitionResources) {
            DatasetResourceReference ref = DatasetResourceReference.of((LocalResource)ls);
            IIndexCheckpointManager indexCheckpointManager = indexCheckpointManagerProvider.get((ResourceReference)ref);
            Path indexPath = StoragePathUtil.getIndexPath((IIOManager)ioManager, (ResourceReference)ref);
            String[] files = indexPath.toFile().list(AbstractLSMIndexFileManager.COMPONENT_FILES_FILTER);
            if (files == null) {
                throw HyracksDataException.create((Throwable)new IOException(indexPath + " is not a directory or an IO Error occurred"));
            }
            long maxComponentSequence = -1L;
            for (String file : files) {
                maxComponentSequence = Math.max(maxComponentSequence, IndexComponentFileReference.of((String)file).getSequenceEnd());
            }
            if (indexCheckpointManager.getCheckpointCount() > 0) {
                indexCheckpointManager.flushed(maxComponentSequence, currentLSN, this.maxComponentId, this.masterNodeId);
                continue;
            }
            indexCheckpointManager.init(maxComponentSequence, currentLSN, this.maxComponentId, this.masterNodeId);
        }
        ReplicationProtocol.sendAck(worker.getChannel(), worker.getReusableBuffer());
    }

    @Override
    public ReplicationProtocol.ReplicationRequestType getMessageType() {
        return ReplicationProtocol.ReplicationRequestType.CHECKPOINT_PARTITION;
    }

    @Override
    public void serialize(OutputStream out) throws HyracksDataException {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeInt(this.partition);
            dos.writeLong(this.maxComponentId);
            boolean hasMaster = this.masterNodeId != null;
            dos.writeBoolean(hasMaster);
            if (hasMaster) {
                dos.writeUTF(this.masterNodeId);
            }
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }

    public static CheckpointPartitionIndexesTask create(DataInput input) throws HyracksDataException {
        try {
            int partition = input.readInt();
            long maxComponentId = input.readLong();
            boolean hasMaster = input.readBoolean();
            String masterNodeId = hasMaster ? input.readUTF() : null;
            return new CheckpointPartitionIndexesTask(partition, maxComponentId, masterNodeId);
        }
        catch (IOException e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

