/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.common.storage;

import java.net.InetSocketAddress;
import org.apache.hyracks.util.NetworkUtil;

public class ReplicaIdentifier {
    private final int partition;
    private final String id;
    private final String nodeId;
    private volatile InetSocketAddress location;

    private ReplicaIdentifier(int partition, String nodeId, InetSocketAddress location) {
        this.partition = partition;
        this.nodeId = nodeId;
        this.location = location;
        this.id = partition + "@" + location.getHostString() + ":" + location.getPort();
    }

    public static ReplicaIdentifier of(int partition, String nodeId, InetSocketAddress location) {
        return new ReplicaIdentifier(partition, nodeId, location);
    }

    public int getPartition() {
        return this.partition;
    }

    public InetSocketAddress getLocation() {
        return this.location;
    }

    public InetSocketAddress refreshLocation() {
        this.location = NetworkUtil.refresh((InetSocketAddress)this.location);
        return this.location;
    }

    public String getNodeId() {
        return this.nodeId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReplicaIdentifier that = (ReplicaIdentifier)o;
        return this.id.equals(that.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public String getId() {
        return this.id;
    }

    public String toString() {
        return this.id;
    }
}

