/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.core.algebra.operators.logical;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalVariable;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractUnnestOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.IOperatorSchema;
import org.apache.hyracks.algebricks.core.algebra.properties.VariablePropagationPolicy;

public abstract class AbstractUnnestNonMapOperator
extends AbstractUnnestOperator {
    protected LogicalVariable positionalVariable;
    protected Object positionalVariableType;

    public AbstractUnnestNonMapOperator(LogicalVariable variable, Mutable<ILogicalExpression> expression) {
        super(AbstractUnnestNonMapOperator.makeSingletonList(variable), expression);
    }

    public AbstractUnnestNonMapOperator(LogicalVariable variable, Mutable<ILogicalExpression> expression, LogicalVariable positionalVariable, Object positionalVariableType) {
        this(variable, expression);
        this.setPositionalVariable(positionalVariable);
        this.setPositionalVariableType(positionalVariableType);
    }

    public LogicalVariable getVariable() {
        return (LogicalVariable)this.variables.get(0);
    }

    public void setPositionalVariable(LogicalVariable positionalVariable) {
        this.positionalVariable = positionalVariable;
    }

    public LogicalVariable getPositionalVariable() {
        return this.positionalVariable;
    }

    public boolean hasPositionalVariable() {
        return this.positionalVariable != null;
    }

    public void setPositionalVariableType(Object positionalVariableType) {
        this.positionalVariableType = positionalVariableType;
    }

    public Object getPositionalVariableType() {
        return this.positionalVariableType;
    }

    @Override
    public boolean isMap() {
        return true;
    }

    protected static <E> List<E> makeSingletonList(E item) {
        ArrayList<E> array = new ArrayList<E>(1);
        array.add(item);
        return array;
    }

    @Override
    public VariablePropagationPolicy getVariablePropagationPolicy() {
        return new VariablePropagationPolicy(){

            @Override
            public void propagateVariables(IOperatorSchema target, IOperatorSchema ... sources) {
                if (sources.length > 0) {
                    target.addAllVariables(sources[0]);
                }
                for (LogicalVariable v : AbstractUnnestNonMapOperator.this.variables) {
                    target.addVariable(v);
                }
                if (AbstractUnnestNonMapOperator.this.positionalVariable != null) {
                    target.addVariable(AbstractUnnestNonMapOperator.this.positionalVariable);
                }
            }
        };
    }
}

