/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.http.HttpHeader;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.netty.implementation.DeferredCacheImmutableMap;
import com.azure.core.util.logging.ClientLogger;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class NettyToAzureCoreHttpHeadersWrapper
extends HttpHeaders {
    private static final ClientLogger LOGGER = new ClientLogger(NettyToAzureCoreHttpHeadersWrapper.class);
    private final io.netty.handler.codec.http.HttpHeaders nettyHeaders;
    private Map<String, String> abstractMap;
    private Map<String, String[]> abstractMultiMap;

    public NettyToAzureCoreHttpHeadersWrapper(io.netty.handler.codec.http.HttpHeaders nettyHeaders) {
        this.nettyHeaders = nettyHeaders;
    }

    public int getSize() {
        return this.nettyHeaders.size();
    }

    public HttpHeaders set(String name, String value) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            this.remove(name);
        } else {
            this.nettyHeaders.set(name, (Object)value);
        }
        return this;
    }

    public HttpHeaders set(String name, List<String> values) {
        if (name == null) {
            return this;
        }
        if (values == null) {
            this.remove(name);
        } else {
            this.nettyHeaders.set(name, values);
        }
        return this;
    }

    public HttpHeaders add(String name, String value) {
        if (name == null) {
            return this;
        }
        if (value == null) {
            this.remove(name);
        } else {
            this.nettyHeaders.add(name, (Object)value);
        }
        return this;
    }

    public HttpHeader get(String name) {
        if (this.nettyHeaders.contains(name)) {
            return new NettyHttpHeader(this, name, this.nettyHeaders.getAll(name));
        }
        return null;
    }

    public HttpHeader remove(String name) {
        HttpHeader header = this.get(name);
        this.nettyHeaders.remove(name);
        return header;
    }

    public String getValue(String name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.getValue();
    }

    public String[] getValues(String name) {
        HttpHeader header = this.get(name);
        return header == null ? null : header.getValues();
    }

    public Map<String, String> toMap() {
        if (this.abstractMap == null) {
            this.abstractMap = new DeferredCacheImmutableMap<String>(LOGGER, new HashMap(), this.nettyHeaders, getAll -> String.join((CharSequence)",", getAll));
        }
        return this.abstractMap;
    }

    Map<String, String[]> toMultiMap() {
        if (this.abstractMultiMap == null) {
            this.abstractMultiMap = new DeferredCacheImmutableMap<String[]>(LOGGER, new HashMap(), this.nettyHeaders, getAll -> getAll.toArray(new String[0]));
        }
        return this.abstractMultiMap;
    }

    public Iterator<HttpHeader> iterator() {
        return this.stream().iterator();
    }

    public Stream<HttpHeader> stream() {
        return this.nettyHeaders.names().stream().map(name -> new NettyHttpHeader(this, (String)name, this.nettyHeaders.getAll(name)));
    }

    static class NettyHttpHeader
    extends HttpHeader {
        private final NettyToAzureCoreHttpHeadersWrapper allHeaders;

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, String value) {
            super(name, value);
            this.allHeaders = allHeaders;
        }

        NettyHttpHeader(NettyToAzureCoreHttpHeadersWrapper allHeaders, String name, List<String> values) {
            super(name, values);
            this.allHeaders = allHeaders;
        }

        public void addValue(String value) {
            super.addValue(value);
            this.allHeaders.add(this.getName(), value);
        }
    }
}

