/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.runtime.evaluators.constructors;

import java.io.DataOutput;
import java.io.Serializable;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.om.exceptions.ExceptionUtil;
import org.apache.asterix.om.types.ATypeTag;
import org.apache.asterix.om.types.BuiltinType;
import org.apache.asterix.runtime.evaluators.functions.PointableHelper;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.runtime.base.IEvaluatorContext;
import org.apache.hyracks.algebricks.runtime.base.IScalarEvaluator;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IError;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import org.apache.hyracks.api.exceptions.SourceLocation;
import org.apache.hyracks.api.exceptions.Warning;
import org.apache.hyracks.data.std.api.IPointable;
import org.apache.hyracks.data.std.primitive.UTF8StringPointable;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.dataflow.common.data.accessors.IFrameTupleReference;
import org.apache.hyracks.util.LogRedactionUtil;

public abstract class AbstractConstructorEvaluator
implements IScalarEvaluator {
    protected final IEvaluatorContext ctx;
    protected final IScalarEvaluator inputEval;
    protected final SourceLocation sourceLoc;
    protected final IPointable inputArg;
    protected final ArrayBackedValueStorage resultStorage;
    protected final DataOutput out;

    protected AbstractConstructorEvaluator(IEvaluatorContext ctx, IScalarEvaluator inputEval, SourceLocation sourceLoc) {
        this.ctx = ctx;
        this.inputEval = inputEval;
        this.sourceLoc = sourceLoc;
        this.inputArg = new VoidPointable();
        this.resultStorage = new ArrayBackedValueStorage();
        this.out = this.resultStorage.getDataOutput();
    }

    public final void evaluate(IFrameTupleReference tuple, IPointable result) throws HyracksDataException {
        this.evaluateInput(tuple);
        if (this.checkAndSetMissingOrNull(result)) {
            return;
        }
        this.evaluateImpl(result);
    }

    protected void evaluateInput(IFrameTupleReference tuple) throws HyracksDataException {
        this.inputEval.evaluate(tuple, this.inputArg);
    }

    protected boolean checkAndSetMissingOrNull(IPointable result) throws HyracksDataException {
        return PointableHelper.checkAndSetMissingOrNull(result, this.inputArg);
    }

    protected abstract void evaluateImpl(IPointable var1) throws HyracksDataException;

    protected abstract FunctionIdentifier getIdentifier();

    protected abstract BuiltinType getTargetType();

    protected void handleUnsupportedType(ATypeTag inputType, IPointable result) throws HyracksDataException {
        this.warnUnsupportedType(inputType);
        PointableHelper.setNull(result);
    }

    protected void warnUnsupportedType(ATypeTag inputType) {
        ExceptionUtil.warnUnsupportedType((IEvaluatorContext)this.ctx, (SourceLocation)this.sourceLoc, (String)(this.getIdentifier().getName() + "()"), (ATypeTag)inputType);
    }

    protected void handleParseError(UTF8StringPointable textPtr, IPointable result) {
        this.warnParseError(textPtr);
        PointableHelper.setNull(result);
    }

    protected void warnParseError(UTF8StringPointable textPtr) {
        IWarningCollector warningCollector = this.ctx.getWarningCollector();
        if (warningCollector.shouldWarn()) {
            warningCollector.warn(Warning.of((SourceLocation)this.sourceLoc, (IError)ErrorCode.INVALID_FORMAT, (Serializable[])new Serializable[]{this.getTargetType().getTypeTag().toString(), LogRedactionUtil.userData((String)textPtr.toString())}));
        }
    }
}

