/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.nc.work;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hyracks.api.control.CcId;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.control.common.job.profiling.om.JobProfile;
import org.apache.hyracks.control.common.job.profiling.om.JobletProfile;
import org.apache.hyracks.control.common.work.FutureValue;
import org.apache.hyracks.control.common.work.SynchronizableWork;
import org.apache.hyracks.control.nc.Joblet;
import org.apache.hyracks.control.nc.NodeControllerService;

public class BuildJobProfilesWork
extends SynchronizableWork {
    private final NodeControllerService ncs;
    private final CcId ccId;
    private final FutureValue<List<JobProfile>> fv;

    public BuildJobProfilesWork(NodeControllerService ncs, CcId ccId, FutureValue<List<JobProfile>> fv) {
        this.ncs = ncs;
        this.ccId = ccId;
        this.fv = fv;
    }

    protected void doRun() throws Exception {
        ArrayList profiles = new ArrayList();
        Map<JobId, Joblet> jobletMap = this.ncs.getJobletMap();
        jobletMap.values().stream().filter(ji -> ji.getJobId().getCcId().equals((Object)this.ccId)).forEach(ji -> profiles.add(new JobProfile(ji.getJobId())));
        for (JobProfile jProfile : profiles) {
            JobletProfile jobletProfile = new JobletProfile(this.ncs.getId());
            Joblet ji2 = jobletMap.get(jProfile.getJobId());
            if (ji2 == null) continue;
            ji2.dumpProfile(jobletProfile);
            jProfile.getJobletProfiles().put(this.ncs.getId(), jobletProfile);
        }
        this.fv.setValue(profiles);
    }
}

