/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.aws;

import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.asterix.external.api.AsterixInputStream;
import org.apache.asterix.external.input.record.reader.abstracts.AbstractExternalInputStreamFactory;
import org.apache.asterix.external.input.record.reader.aws.AwsS3InputStream;
import org.apache.asterix.external.util.ExternalDataUtils;
import org.apache.asterix.external.util.aws.s3.S3Utils;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.api.application.IServiceContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.IWarningCollector;
import software.amazon.awssdk.services.s3.model.S3Object;

public class AwsS3InputStreamFactory
extends AbstractExternalInputStreamFactory {
    private static final long serialVersionUID = 1L;

    @Override
    public AsterixInputStream createInputStream(IHyracksTaskContext ctx, int partition) throws HyracksDataException {
        return new AwsS3InputStream(this.configuration, ((AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize)this.partitionWorkLoadsBasedOnSize.get(partition)).getFilePaths());
    }

    @Override
    public void configure(IServiceContext ctx, Map<String, String> configuration, IWarningCollector warningCollector) throws AlgebricksException {
        super.configure(ctx, configuration, warningCollector);
        ExternalDataUtils.validateIncludeExclude(configuration);
        AbstractExternalInputStreamFactory.IncludeExcludeMatcher includeExcludeMatcher = ExternalDataUtils.getIncludeExcludeMatchers(configuration);
        List<S3Object> filesOnly = S3Utils.listS3Objects(configuration, includeExcludeMatcher, warningCollector);
        this.distributeWorkLoad(filesOnly, this.getPartitionsCount());
    }

    private void distributeWorkLoad(List<S3Object> fileObjects, int partitionsCount) {
        PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize> workloadQueue = new PriorityQueue<AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize>(partitionsCount, Comparator.comparingLong(AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize::getTotalSize));
        for (int i = 0; i < partitionsCount; ++i) {
            workloadQueue.add(new AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize());
        }
        for (S3Object object : fileObjects) {
            AbstractExternalInputStreamFactory.PartitionWorkLoadBasedOnSize workload = workloadQueue.poll();
            workload.addFilePath(object.key(), object.size());
            workloadQueue.add(workload);
        }
        this.partitionWorkLoadsBasedOnSize.addAll(workloadQueue);
    }
}

