/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.input.record.reader.hdfs.parquet;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.List;
import org.apache.asterix.common.exceptions.ErrorCode;
import org.apache.asterix.common.exceptions.RuntimeDataException;
import org.apache.asterix.external.input.record.reader.hdfs.parquet.AsterixParquetRuntimeException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.FileSplit;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.RecordReader;
import org.apache.hadoop.mapred.Reporter;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.data.std.api.IValueReference;
import org.apache.hyracks.data.std.primitive.VoidPointable;
import org.apache.hyracks.data.std.util.ArrayBackedValueStorage;
import org.apache.hyracks.util.LogRedactionUtil;
import org.apache.parquet.hadoop.Footer;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetInputSplit;
import org.apache.parquet.hadoop.ParquetRecordReader;

public class MapredParquetInputFormat
extends FileInputFormat<Void, VoidPointable> {
    protected ParquetInputFormat<ArrayBackedValueStorage> realInputFormat = new ParquetInputFormat();

    public RecordReader<Void, VoidPointable> getRecordReader(org.apache.hadoop.mapred.InputSplit split, JobConf job, Reporter reporter) throws IOException {
        return new RecordReaderWrapper(split, job, reporter);
    }

    public org.apache.hadoop.mapred.InputSplit[] getSplits(JobConf job, int numSplits) throws IOException {
        if (MapredParquetInputFormat.isTaskSideMetaData(job)) {
            return super.getSplits(job, numSplits);
        }
        List<Footer> footers = this.getFooters(job);
        List splits = this.realInputFormat.getSplits((Configuration)job, footers);
        if (splits == null) {
            return null;
        }
        org.apache.hadoop.mapred.InputSplit[] resultSplits = new org.apache.hadoop.mapred.InputSplit[splits.size()];
        int i = 0;
        for (ParquetInputSplit split : splits) {
            resultSplits[i++] = new ParquetInputSplitWrapper(split);
        }
        return resultSplits;
    }

    public List<Footer> getFooters(JobConf job) throws IOException {
        return this.realInputFormat.getFooters((Configuration)job, Arrays.asList(super.listStatus(job)));
    }

    public static boolean isTaskSideMetaData(JobConf job) {
        return job.getBoolean("parquet.task.side.metadata", true);
    }

    private static class RecordReaderWrapper
    implements RecordReader<Void, VoidPointable> {
        private final ParquetRecordReader<IValueReference> realReader;
        private final long splitLen;
        private final VoidPointable valueContainer;
        private boolean firstRecord;
        private boolean eof;

        public RecordReaderWrapper(org.apache.hadoop.mapred.InputSplit oldSplit, JobConf oldJobConf, Reporter reporter) throws IOException {
            this.splitLen = oldSplit.getLength();
            try {
                this.realReader = new ParquetRecordReader(ParquetInputFormat.getReadSupportInstance((Configuration)oldJobConf), ParquetInputFormat.getFilter((Configuration)oldJobConf));
                if (oldSplit instanceof ParquetInputSplitWrapper) {
                    this.realReader.initialize((InputSplit)((ParquetInputSplitWrapper)oldSplit).realSplit, (Configuration)oldJobConf, reporter);
                } else if (oldSplit instanceof FileSplit) {
                    this.realReader.initialize((InputSplit)((FileSplit)oldSplit), (Configuration)oldJobConf, reporter);
                } else {
                    throw RuntimeDataException.create((ErrorCode)ErrorCode.INVALID_PARQUET_FILE, (Serializable[])new Serializable[]{LogRedactionUtil.userData((String)oldSplit.toString()), "invalid file split"});
                }
                this.valueContainer = new VoidPointable();
                this.firstRecord = false;
                this.eof = false;
                if (this.realReader.nextKeyValue()) {
                    this.firstRecord = true;
                    this.valueContainer.set((IValueReference)this.realReader.getCurrentValue());
                } else {
                    this.eof = true;
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            catch (AsterixParquetRuntimeException | HyracksDataException e) {
                throw e;
            }
            catch (Exception e) {
                if (e.getMessage() != null && e.getMessage().contains("not a Parquet file")) {
                    throw RuntimeDataException.create((ErrorCode)ErrorCode.INVALID_PARQUET_FILE, (Serializable[])new Serializable[]{LogRedactionUtil.userData((String)this.getPath(oldSplit)), "not a Parquet file"});
                }
                throw RuntimeDataException.create((ErrorCode)ErrorCode.UNEXPECTED_ERROR_ENCOUNTERED, (Serializable[])new Serializable[]{LogRedactionUtil.userData((String)e.toString())});
            }
        }

        private String getPath(org.apache.hadoop.mapred.InputSplit split) {
            if (split instanceof FileSplit) {
                return ((FileSplit)split).getPath().toString();
            }
            if (split instanceof ParquetInputSplitWrapper) {
                return ((ParquetInputSplitWrapper)split).realSplit.getPath().toString();
            }
            return split.toString();
        }

        public void close() throws IOException {
            this.realReader.close();
        }

        public Void createKey() {
            return null;
        }

        public VoidPointable createValue() {
            return this.valueContainer;
        }

        public long getPos() throws IOException {
            return (long)((float)this.splitLen * this.getProgress());
        }

        public float getProgress() throws IOException {
            try {
                return this.realReader.getProgress();
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
        }

        public boolean next(Void key, VoidPointable value) throws IOException {
            if (this.eof) {
                return false;
            }
            if (this.firstRecord) {
                this.firstRecord = false;
                value.set((IValueReference)this.valueContainer);
                return true;
            }
            try {
                if (this.realReader.nextKeyValue()) {
                    if (value != null) {
                        value.set((IValueReference)this.realReader.getCurrentValue());
                    }
                    return true;
                }
            }
            catch (InterruptedException e) {
                throw new IOException(e);
            }
            this.eof = true;
            return false;
        }
    }

    private static class ParquetInputSplitWrapper
    implements org.apache.hadoop.mapred.InputSplit {
        ParquetInputSplit realSplit;

        public ParquetInputSplitWrapper() {
        }

        public ParquetInputSplitWrapper(ParquetInputSplit realSplit) {
            this.realSplit = realSplit;
        }

        public long getLength() throws IOException {
            return this.realSplit.getLength();
        }

        public String[] getLocations() throws IOException {
            return this.realSplit.getLocations();
        }

        public void readFields(DataInput in) throws IOException {
            this.realSplit = new ParquetInputSplit();
            this.realSplit.readFields(in);
        }

        public void write(DataOutput out) throws IOException {
            this.realSplit.write(out);
        }

        public String toString() {
            return this.realSplit.toString();
        }
    }
}

