/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.external.operators;

import java.io.DataOutput;
import java.io.IOException;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.value.IMissingWriterFactory;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.data.accessors.FrameTupleReference;
import org.apache.hyracks.storage.am.common.api.ISearchOperationCallbackFactory;
import org.apache.hyracks.storage.am.common.dataflow.IIndexDataflowHelperFactory;
import org.apache.hyracks.storage.am.lsm.rtree.impls.ExternalRTree;
import org.apache.hyracks.storage.am.rtree.dataflow.RTreeSearchOperatorNodePushable;
import org.apache.hyracks.storage.common.ISearchOperationCallback;

public class ExternalRTreeSearchOperatorNodePushable
extends RTreeSearchOperatorNodePushable {
    private final int version;

    public ExternalRTreeSearchOperatorNodePushable(IHyracksTaskContext ctx, int partition, RecordDescriptor inputRecDesc, int[] keyFields, int[] minFilterFieldIndexes, int[] maxFilterFieldIndexes, IIndexDataflowHelperFactory indexHelperFactory, boolean retainInput, boolean retainMissing, IMissingWriterFactory missingWriterFactory, ISearchOperationCallbackFactory searchCallbackFactory, int version) throws HyracksDataException {
        super(ctx, partition, inputRecDesc, keyFields, minFilterFieldIndexes, maxFilterFieldIndexes, indexHelperFactory, retainInput, retainMissing, missingWriterFactory, searchCallbackFactory, false, null);
        this.version = version;
    }

    public void open() throws HyracksDataException {
        this.writer.open();
        this.accessor = new FrameTupleAccessor(this.inputRecDesc);
        this.indexHelper.open();
        this.index = this.indexHelper.getIndexInstance();
        if (this.retainMissing) {
            int fieldCount = this.getFieldCount();
            this.nonMatchTupleBuild = new ArrayTupleBuilder(fieldCount);
            DataOutput out = this.nonMatchTupleBuild.getDataOutput();
            for (int i = 0; i < fieldCount; ++i) {
                try {
                    this.nonMatchWriter.writeMissing(out);
                }
                catch (IOException e) {
                    throw HyracksDataException.create((Throwable)e);
                }
                this.nonMatchTupleBuild.addFieldEndOffset();
            }
        } else {
            this.nonMatchTupleBuild = null;
        }
        ExternalRTree rTreeIndex = (ExternalRTree)this.index;
        try {
            this.searchPred = this.createSearchPredicate();
            this.tb = new ArrayTupleBuilder(this.recordDesc.getFieldCount());
            this.dos = this.tb.getDataOutput();
            this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)this.ctx));
            ISearchOperationCallback searchCallback = this.searchCallbackFactory.createSearchOperationCallback(this.indexHelper.getResource().getId(), this.ctx, null);
            this.indexAccessor = rTreeIndex.createAccessor(searchCallback, this.version);
            this.cursor = this.createCursor();
            if (this.retainInput) {
                this.frameTuple = new FrameTupleReference();
            }
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
    }
}

