/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.dataflow.std.intersect;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.BitSet;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IActivityGraphBuilder;
import org.apache.hyracks.api.dataflow.IOperatorDescriptor;
import org.apache.hyracks.api.dataflow.IOperatorNodePushable;
import org.apache.hyracks.api.dataflow.value.IBinaryComparator;
import org.apache.hyracks.api.dataflow.value.IBinaryComparatorFactory;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputer;
import org.apache.hyracks.api.dataflow.value.INormalizedKeyComputerFactory;
import org.apache.hyracks.api.dataflow.value.IRecordDescriptorProvider;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.ErrorCode;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.IOperatorDescriptorRegistry;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.utils.NormalizedKeyUtils;
import org.apache.hyracks.dataflow.std.base.AbstractActivityNode;
import org.apache.hyracks.dataflow.std.base.AbstractOperatorDescriptor;
import org.apache.hyracks.dataflow.std.base.AbstractUnaryOutputOperatorNodePushable;

public class IntersectOperatorDescriptor
extends AbstractOperatorDescriptor {
    private static final long serialVersionUID = 1L;
    private final int[][] compareFields;
    private final int[][] extraFields;
    private final INormalizedKeyComputerFactory firstKeyNormalizerFactory;
    private final IBinaryComparatorFactory[] comparatorFactory;

    public IntersectOperatorDescriptor(IOperatorDescriptorRegistry spec, int nInputs, int[][] compareFields, int[][] extraFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactories, RecordDescriptor recordDescriptor) throws HyracksException {
        super(spec, nInputs, 1);
        this.outRecDescs[0] = recordDescriptor;
        this.validateParameters(compareFields, comparatorFactories, extraFields);
        this.compareFields = compareFields;
        this.extraFields = extraFields;
        this.firstKeyNormalizerFactory = firstKeyNormalizerFactory;
        this.comparatorFactory = comparatorFactories;
    }

    private void validateParameters(int[][] compareFields, IBinaryComparatorFactory[] comparatorFactories, int[][] extraFields) throws HyracksException {
        int firstLength = compareFields[0].length;
        for (int[] fields : compareFields) {
            if (fields.length != firstLength) {
                throw HyracksException.create((ErrorCode)ErrorCode.INVALID_INPUT_PARAMETER, (Serializable[])new Serializable[0]);
            }
            for (int fid : fields) {
                if (fid >= 0) continue;
                throw HyracksException.create((ErrorCode)ErrorCode.INVALID_INPUT_PARAMETER, (Serializable[])new Serializable[0]);
            }
        }
        if (firstLength != comparatorFactories.length) {
            throw HyracksException.create((ErrorCode)ErrorCode.INVALID_INPUT_PARAMETER, (Serializable[])new Serializable[0]);
        }
        if (extraFields != null) {
            firstLength = extraFields[0].length;
            for (int[] fields : extraFields) {
                if (fields.length == firstLength) continue;
                throw HyracksException.create((ErrorCode)ErrorCode.INVALID_INPUT_PARAMETER, (Serializable[])new Serializable[0]);
            }
        }
    }

    public void contributeActivities(IActivityGraphBuilder builder) {
        IntersectActivity intersectActivity = new IntersectActivity(new ActivityId(this.getOperatorId(), 0));
        builder.addActivity((IOperatorDescriptor)this, (IActivity)intersectActivity);
        for (int i = 0; i < this.getInputArity(); ++i) {
            builder.addSourceEdge(i, (IActivity)intersectActivity, i);
        }
        builder.addTargetEdge(0, (IActivity)intersectActivity, 0);
    }

    private class IntersectActivity
    extends AbstractActivityNode {
        private static final long serialVersionUID = 1L;

        public IntersectActivity(ActivityId activityId) {
            super(activityId);
        }

        public IOperatorNodePushable createPushRuntime(IHyracksTaskContext ctx, IRecordDescriptorProvider recordDescProvider, int partition, int nPartitions) throws HyracksDataException {
            RecordDescriptor[] inputRecordDesc = new RecordDescriptor[IntersectOperatorDescriptor.this.inputArity];
            for (int i = 0; i < inputRecordDesc.length; ++i) {
                inputRecordDesc[i] = recordDescProvider.getInputRecordDescriptor(this.getActivityId(), i);
            }
            return new IntersectOperatorNodePushable(ctx, IntersectOperatorDescriptor.this.inputArity, inputRecordDesc, IntersectOperatorDescriptor.this.compareFields, IntersectOperatorDescriptor.this.extraFields, IntersectOperatorDescriptor.this.firstKeyNormalizerFactory, IntersectOperatorDescriptor.this.comparatorFactory);
        }
    }

    public static class IntersectOperatorNodePushable
    extends AbstractUnaryOutputOperatorNodePushable {
        private final int inputArity;
        private final int[][] compareFields;
        private final int[][] allProjectFields;
        private final BitSet consumed;
        private final int[] tupleIndexMarker;
        private final FrameTupleAccessor[] refAccessor;
        private final FrameTupleAppender appender;
        private final INormalizedKeyComputer firstKeyNormalizerComputer;
        private final boolean normalizedKeyDecisive;
        private final IBinaryComparator[] comparators;
        private boolean done = false;

        public IntersectOperatorNodePushable(IHyracksTaskContext ctx, int inputArity, RecordDescriptor[] inputRecordDescriptors, int[][] compareFields, int[][] extraFields, INormalizedKeyComputerFactory firstKeyNormalizerFactory, IBinaryComparatorFactory[] comparatorFactory) throws HyracksDataException {
            int i;
            this.inputArity = inputArity;
            this.compareFields = compareFields;
            Object projectedFields = compareFields;
            if (extraFields != null) {
                projectedFields = new int[inputArity][];
                for (int input = 0; input < inputArity; ++input) {
                    projectedFields[input] = new int[compareFields[input].length + extraFields[input].length];
                    for (int j = 0; j < compareFields[input].length; ++j) {
                        projectedFields[input][j] = compareFields[input][j];
                    }
                    for (int k = 0; k < extraFields[input].length; ++k) {
                        projectedFields[input][j + k] = extraFields[input][k];
                    }
                }
            }
            this.allProjectFields = projectedFields;
            INormalizedKeyComputer iNormalizedKeyComputer = this.firstKeyNormalizerComputer = firstKeyNormalizerFactory != null ? firstKeyNormalizerFactory.createNormalizedKeyComputer() : null;
            this.normalizedKeyDecisive = firstKeyNormalizerFactory != null ? firstKeyNormalizerFactory.getNormalizedKeyProperties().isDecisive() && compareFields[0].length == 1 : false;
            this.comparators = new IBinaryComparator[compareFields[0].length];
            for (i = 0; i < this.comparators.length; ++i) {
                this.comparators[i] = comparatorFactory[i].createBinaryComparator();
            }
            this.appender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx));
            this.refAccessor = new FrameTupleAccessor[inputArity];
            for (i = 0; i < inputArity; ++i) {
                this.refAccessor[i] = new FrameTupleAccessor(inputRecordDescriptors[i]);
            }
            this.consumed = new BitSet(inputArity);
            this.consumed.set(0, inputArity);
            this.tupleIndexMarker = new int[inputArity];
        }

        public int getInputArity() {
            return this.inputArity;
        }

        @Override
        public String getDisplayName() {
            return "Intersect";
        }

        public IFrameWriter getInputFrameWriter(final int index) {
            return new IFrameWriter(){
                private final int[] normalizedKey1;
                private final int[] normalizedKey2;
                {
                    this.normalizedKey1 = NormalizedKeyUtils.createNormalizedKeyArray((INormalizedKeyComputer)firstKeyNormalizerComputer);
                    this.normalizedKey2 = NormalizedKeyUtils.createNormalizedKeyArray((INormalizedKeyComputer)firstKeyNormalizerComputer);
                }

                public void open() throws HyracksDataException {
                    if (index == 0) {
                        writer.open();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
                    IntersectOperatorNodePushable intersectOperatorNodePushable = this;
                    synchronized (intersectOperatorNodePushable) {
                        if (done) {
                            return;
                        }
                        refAccessor[index].reset(buffer);
                        tupleIndexMarker[index] = 0;
                        consumed.clear(index);
                        if (index != 0) {
                            if (this.allInputArrived()) {
                                this.notifyAll();
                            }
                            while (!consumed.get(index) && !done) {
                                this.waitOrHyracksException();
                            }
                        } else {
                            while (!consumed.get(0)) {
                                while (!this.allInputArrived() && !done) {
                                    this.waitOrHyracksException();
                                }
                                if (!done) {
                                    this.intersectAllInputs();
                                    this.notifyAll();
                                    continue;
                                }
                                break;
                            }
                        }
                    }
                }

                private void waitOrHyracksException() throws HyracksDataException {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        throw HyracksDataException.create((Throwable)e);
                    }
                }

                private boolean allInputArrived() {
                    return consumed.cardinality() == 0;
                }

                private void intersectAllInputs() throws HyracksDataException {
                    do {
                        int i;
                        int maxInput = this.findMaxInput();
                        int match = 1;
                        boolean needToUpdateMax = false;
                        for (i = 0; i < inputArity; ++i) {
                            if (i == maxInput) continue;
                            while (tupleIndexMarker[i] < refAccessor[i].getTupleCount()) {
                                int cmp = this.compare(i, refAccessor[i], tupleIndexMarker[i], maxInput, refAccessor[maxInput], tupleIndexMarker[maxInput]);
                                if (cmp == 0) {
                                    ++match;
                                    break;
                                }
                                if (cmp < 0) {
                                    int n = i;
                                    tupleIndexMarker[n] = tupleIndexMarker[n] + 1;
                                    continue;
                                }
                                needToUpdateMax = true;
                                break;
                            }
                            if (tupleIndexMarker[i] < refAccessor[i].getTupleCount()) continue;
                            consumed.set(i);
                        }
                        if (match == inputArity) {
                            FrameUtils.appendProjectionToWriter((IFrameWriter)writer, (IFrameTupleAppender)appender, (IFrameTupleAccessor)refAccessor[maxInput], (int)tupleIndexMarker[maxInput], (int[])allProjectFields[maxInput]);
                            for (i = 0; i < inputArity; ++i) {
                                int n = i;
                                tupleIndexMarker[n] = tupleIndexMarker[n] + 1;
                                if (tupleIndexMarker[i] < refAccessor[i].getTupleCount()) continue;
                                consumed.set(i);
                            }
                        } else {
                            if (!needToUpdateMax) continue;
                            int n = maxInput;
                            tupleIndexMarker[n] = tupleIndexMarker[n] + 1;
                            if (tupleIndexMarker[maxInput] < refAccessor[maxInput].getTupleCount()) continue;
                            consumed.set(maxInput);
                        }
                    } while (consumed.nextSetBit(0) < 0);
                    appender.write(writer, true);
                }

                private int compare(int input1, FrameTupleAccessor frameTupleAccessor1, int tid1, int input2, FrameTupleAccessor frameTupleAccessor2, int tid2) throws HyracksDataException {
                    if (firstKeyNormalizerComputer != null) {
                        this.getFirstNorm(input1, frameTupleAccessor1, tid1, this.normalizedKey1);
                        this.getFirstNorm(input2, frameTupleAccessor2, tid2, this.normalizedKey2);
                        int cmp = NormalizedKeyUtils.compareNormalizeKeys((int[])this.normalizedKey1, (int)0, (int[])this.normalizedKey2, (int)0, (int)this.normalizedKey1.length);
                        if (cmp != 0 || normalizedKeyDecisive) {
                            return cmp;
                        }
                    }
                    for (int i = 0; i < comparators.length; ++i) {
                        int cmp = comparators[i].compare(frameTupleAccessor1.getBuffer().array(), frameTupleAccessor1.getAbsoluteFieldStartOffset(tid1, compareFields[input1][i]), frameTupleAccessor1.getFieldLength(tid1, compareFields[input1][i]), frameTupleAccessor2.getBuffer().array(), frameTupleAccessor2.getAbsoluteFieldStartOffset(tid2, compareFields[input2][i]), frameTupleAccessor2.getFieldLength(tid2, compareFields[input2][i]));
                        if (cmp == 0) continue;
                        return cmp;
                    }
                    return 0;
                }

                private void getFirstNorm(int inputId1, FrameTupleAccessor frameTupleAccessor1, int tid1, int[] keys) {
                    if (firstKeyNormalizerComputer != null) {
                        firstKeyNormalizerComputer.normalize(frameTupleAccessor1.getBuffer().array(), frameTupleAccessor1.getAbsoluteFieldStartOffset(tid1, compareFields[inputId1][0]), frameTupleAccessor1.getFieldLength(tid1, compareFields[inputId1][0]), keys, 0);
                    }
                }

                private int findMaxInput() throws HyracksDataException {
                    int max = 0;
                    for (int i = 1; i < inputArity; ++i) {
                        int cmp = this.compare(max, refAccessor[max], tupleIndexMarker[max], i, refAccessor[i], tupleIndexMarker[i]);
                        if (cmp >= 0) continue;
                        max = i;
                    }
                    return max;
                }

                public void fail() throws HyracksDataException {
                    this.clearStateWith(ACTION.FAILED);
                }

                public void close() throws HyracksDataException {
                    this.clearStateWith(ACTION.CLOSE);
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                private void clearStateWith(ACTION action) throws HyracksDataException {
                    IntersectOperatorNodePushable intersectOperatorNodePushable = this;
                    synchronized (intersectOperatorNodePushable) {
                        if (index == 0) {
                            this.doAction(action);
                        }
                        if (done) {
                            return;
                        }
                        consumed.set(index);
                        refAccessor[index] = null;
                        done = true;
                        this.notifyAll();
                    }
                }

                private void doAction(ACTION action) throws HyracksDataException {
                    switch (action) {
                        case CLOSE: {
                            writer.close();
                            break;
                        }
                        case FAILED: {
                            writer.fail();
                        }
                    }
                }
            };
        }

        private static enum ACTION {
            FAILED,
            CLOSE;

        }
    }
}

