/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.optimizer.rules;

import java.util.ArrayList;
import java.util.List;
import org.apache.asterix.lang.common.util.FunctionUtil;
import org.apache.asterix.metadata.declared.MetadataProvider;
import org.apache.asterix.om.base.IAObject;
import org.apache.asterix.om.constants.AsterixConstantValue;
import org.apache.asterix.om.functions.BuiltinFunctions;
import org.apache.asterix.optimizer.base.FuzzyUtils;
import org.apache.commons.lang3.mutable.Mutable;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.hyracks.algebricks.common.exceptions.AlgebricksException;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalExpression;
import org.apache.hyracks.algebricks.core.algebra.base.ILogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.base.IOptimizationContext;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalExpressionTag;
import org.apache.hyracks.algebricks.core.algebra.base.LogicalOperatorTag;
import org.apache.hyracks.algebricks.core.algebra.expressions.AbstractFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.ConstantExpression;
import org.apache.hyracks.algebricks.core.algebra.expressions.IAlgebricksConstantValue;
import org.apache.hyracks.algebricks.core.algebra.expressions.IVariableTypeEnvironment;
import org.apache.hyracks.algebricks.core.algebra.expressions.ScalarFunctionCallExpression;
import org.apache.hyracks.algebricks.core.algebra.functions.AlgebricksBuiltinFunctions;
import org.apache.hyracks.algebricks.core.algebra.functions.FunctionIdentifier;
import org.apache.hyracks.algebricks.core.algebra.functions.IFunctionInfo;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractBinaryJoinOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.AbstractLogicalOperator;
import org.apache.hyracks.algebricks.core.algebra.operators.logical.SelectOperator;
import org.apache.hyracks.algebricks.core.rewriter.base.IAlgebraicRewriteRule;
import org.apache.hyracks.api.exceptions.SourceLocation;

public class FuzzyEqRule
implements IAlgebraicRewriteRule {
    public boolean rewritePost(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        Mutable expRef;
        AbstractLogicalOperator op = (AbstractLogicalOperator)opRef.getValue();
        if (op.getOperatorTag() == LogicalOperatorTag.INNERJOIN || op.getOperatorTag() == LogicalOperatorTag.LEFTOUTERJOIN) {
            AbstractBinaryJoinOperator joinOp = (AbstractBinaryJoinOperator)op;
            expRef = joinOp.getCondition();
        } else if (op.getOperatorTag() == LogicalOperatorTag.SELECT) {
            SelectOperator selectOp = (SelectOperator)op;
            expRef = selectOp.getCondition();
        } else {
            return false;
        }
        MetadataProvider metadataProvider = (MetadataProvider)context.getMetadataProvider();
        IVariableTypeEnvironment env = context.getOutputTypeEnvironment((ILogicalOperator)op);
        if (this.expandFuzzyEq((Mutable<ILogicalExpression>)expRef, context, env, metadataProvider)) {
            context.computeAndSetTypeEnvironmentForOperator((ILogicalOperator)op);
            return true;
        }
        return false;
    }

    private boolean expandFuzzyEq(Mutable<ILogicalExpression> expRef, IOptimizationContext context, IVariableTypeEnvironment env, MetadataProvider metadataProvider) throws AlgebricksException {
        ILogicalExpression exp = (ILogicalExpression)expRef.getValue();
        if (exp.getExpressionTag() != LogicalExpressionTag.FUNCTION_CALL) {
            return false;
        }
        boolean expanded = false;
        AbstractFunctionCallExpression funcExp = (AbstractFunctionCallExpression)exp;
        FunctionIdentifier fi = funcExp.getFunctionIdentifier();
        if (fi.equals((Object)BuiltinFunctions.FUZZY_EQ)) {
            SourceLocation sourceLoc = funcExp.getSourceLocation();
            List inputExps = funcExp.getArguments();
            String simFuncName = FuzzyUtils.getSimFunction(metadataProvider);
            ArrayList<Mutable> similarityArgs = new ArrayList<Mutable>();
            for (int i = 0; i < inputExps.size(); ++i) {
                Mutable inputExpRef = (Mutable)inputExps.get(i);
                similarityArgs.add(inputExpRef);
            }
            FunctionIdentifier simFunctionIdentifier = FuzzyUtils.getFunctionIdentifier(simFuncName);
            ScalarFunctionCallExpression similarityExp = new ScalarFunctionCallExpression((IFunctionInfo)FunctionUtil.getFunctionInfo((FunctionIdentifier)simFunctionIdentifier), similarityArgs);
            similarityExp.setSourceLocation(sourceLoc);
            funcExp.copyAnnotationsInto((AbstractFunctionCallExpression)similarityExp);
            ArrayList<Mutable<ILogicalExpression>> cmpArgs = new ArrayList<Mutable<ILogicalExpression>>();
            cmpArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)similarityExp));
            IAObject simThreshold = FuzzyUtils.getSimThreshold(metadataProvider, simFuncName);
            ConstantExpression simThresholdExpr = new ConstantExpression((IAlgebricksConstantValue)new AsterixConstantValue(simThreshold));
            simThresholdExpr.setSourceLocation(sourceLoc);
            cmpArgs.add((Mutable<ILogicalExpression>)new MutableObject((Object)simThresholdExpr));
            ScalarFunctionCallExpression cmpExpr = FuzzyUtils.getComparisonExpr(simFuncName, cmpArgs);
            expRef.setValue((Object)cmpExpr);
            return true;
        }
        if (fi.equals((Object)AlgebricksBuiltinFunctions.AND) || fi.equals((Object)AlgebricksBuiltinFunctions.OR)) {
            for (int i = 0; i < 2; ++i) {
                if (!this.expandFuzzyEq((Mutable<ILogicalExpression>)((Mutable)funcExp.getArguments().get(i)), context, env, metadataProvider)) continue;
                expanded = true;
            }
        }
        return expanded;
    }

    public boolean rewritePre(Mutable<ILogicalOperator> opRef, IOptimizationContext context) throws AlgebricksException {
        return false;
    }
}

