/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.algebricks.runtime.operators.aggreg;

import java.nio.ByteBuffer;
import org.apache.hyracks.algebricks.runtime.base.AlgebricksPipeline;
import org.apache.hyracks.algebricks.runtime.operators.meta.PipelineAssembler;
import org.apache.hyracks.algebricks.runtime.operators.std.NestedTupleSourceRuntimeFactory;
import org.apache.hyracks.api.comm.IFrame;
import org.apache.hyracks.api.comm.IFrameTupleAccessor;
import org.apache.hyracks.api.comm.IFrameTupleAppender;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.comm.VSizeFrame;
import org.apache.hyracks.api.context.IHyracksFrameMgrContext;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.EnforceFrameWriter;
import org.apache.hyracks.api.dataflow.ProfiledFrameWriter;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobFlag;
import org.apache.hyracks.dataflow.common.comm.io.ArrayTupleBuilder;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAccessor;
import org.apache.hyracks.dataflow.common.comm.io.FrameTupleAppender;
import org.apache.hyracks.dataflow.common.comm.util.FrameUtils;
import org.apache.hyracks.dataflow.common.utils.TupleUtils;
import org.apache.hyracks.dataflow.std.group.AbstractAggregatorDescriptorFactory;
import org.apache.hyracks.dataflow.std.group.AggregateState;
import org.apache.hyracks.dataflow.std.group.IAggregatorDescriptor;

public class NestedPlansRunningAggregatorFactory
extends AbstractAggregatorDescriptorFactory {
    private static final long serialVersionUID = 1L;
    private final AlgebricksPipeline[] subplans;
    private final int[] keyFieldIdx;
    private final int[] decorFieldIdx;

    public NestedPlansRunningAggregatorFactory(AlgebricksPipeline[] subplans, int[] keyFieldIdx, int[] decorFieldIdx) {
        this.subplans = subplans;
        this.keyFieldIdx = keyFieldIdx;
        this.decorFieldIdx = decorFieldIdx;
    }

    public IAggregatorDescriptor createAggregator(IHyracksTaskContext ctx, RecordDescriptor inRecordDescriptor, RecordDescriptor outRecordDescriptor, int[] keyFields, int[] keyFieldsInPartialResults, IFrameWriter writer, long memoryBudget) throws HyracksDataException {
        RunningAggregatorOutput outputWriter;
        boolean enforce = ctx.getJobFlags().contains(JobFlag.ENFORCE_CONTRACT);
        boolean profile = ctx.getJobFlags().contains(JobFlag.PROFILE_RUNTIME);
        RunningAggregatorOutput fw = outputWriter = new RunningAggregatorOutput(ctx, this.subplans, this.keyFieldIdx.length + this.decorFieldIdx.length, writer);
        if (profile) {
            fw = ProfiledFrameWriter.time((IFrameWriter)outputWriter, (IHyracksTaskContext)ctx, (String)"Aggregate Writer");
        } else if (enforce) {
            fw = EnforceFrameWriter.enforce((IFrameWriter)outputWriter);
        }
        final NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[] pipelines = new NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime[this.subplans.length];
        for (int i = 0; i < this.subplans.length; ++i) {
            pipelines[i] = (NestedTupleSourceRuntimeFactory.NestedTupleSourceRuntime)PipelineAssembler.assemblePipeline(this.subplans[i], fw, ctx, null);
        }
        final ArrayTupleBuilder gbyTb = outputWriter.getGroupByTupleBuilder();
        return new IAggregatorDescriptor(){

            public void init(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                int i;
                for (i = 0; i < pipelines.length; ++i) {
                    pipelines[i].open();
                }
                gbyTb.reset();
                for (i = 0; i < NestedPlansRunningAggregatorFactory.this.keyFieldIdx.length; ++i) {
                    gbyTb.addField(accessor, tIndex, NestedPlansRunningAggregatorFactory.this.keyFieldIdx[i]);
                }
                for (i = 0; i < NestedPlansRunningAggregatorFactory.this.decorFieldIdx.length; ++i) {
                    gbyTb.addField(accessor, tIndex, NestedPlansRunningAggregatorFactory.this.decorFieldIdx[i]);
                }
                for (i = 0; i < pipelines.length; ++i) {
                    outputWriter.setInputIdx(i);
                    pipelines[i].writeTuple(accessor.getBuffer(), tIndex);
                }
            }

            public void aggregate(IFrameTupleAccessor accessor, int tIndex, IFrameTupleAccessor stateAccessor, int stateTupleIndex, AggregateState state) throws HyracksDataException {
                for (int i = 0; i < pipelines.length; ++i) {
                    outputWriter.setInputIdx(i);
                    pipelines[i].writeTuple(accessor.getBuffer(), tIndex);
                }
            }

            public boolean outputFinalResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                for (int i = 0; i < pipelines.length; ++i) {
                    outputWriter.setInputIdx(i);
                    pipelines[i].close();
                }
                return false;
            }

            public AggregateState createAggregateStates() {
                return new AggregateState();
            }

            public void reset() {
            }

            public boolean outputPartialResult(ArrayTupleBuilder tupleBuilder, IFrameTupleAccessor accessor, int tIndex, AggregateState state) throws HyracksDataException {
                throw new IllegalStateException("this method should not be called");
            }

            public void close() {
            }
        };
    }

    private static class RunningAggregatorOutput
    implements IFrameWriter {
        private final FrameTupleAccessor[] tAccess;
        private final RecordDescriptor[] inputRecDesc;
        private int inputIdx;
        private final ArrayTupleBuilder tb;
        private final ArrayTupleBuilder gbyTb;
        private final AlgebricksPipeline[] subplans;
        private final IFrameWriter outputWriter;
        private final FrameTupleAppender outputAppender;

        public RunningAggregatorOutput(IHyracksTaskContext ctx, AlgebricksPipeline[] subplans, int numPropagatedFields, IFrameWriter outputWriter) throws HyracksDataException {
            int i;
            this.subplans = subplans;
            this.outputWriter = outputWriter;
            int totalAggFields = 0;
            this.inputRecDesc = new RecordDescriptor[subplans.length];
            for (i = 0; i < subplans.length; ++i) {
                RecordDescriptor[] rd = subplans[i].getRecordDescriptors();
                this.inputRecDesc[i] = rd[rd.length - 1];
                totalAggFields += subplans[i].getOutputWidth();
            }
            this.tb = new ArrayTupleBuilder(numPropagatedFields + totalAggFields);
            this.gbyTb = new ArrayTupleBuilder(numPropagatedFields);
            this.tAccess = new FrameTupleAccessor[this.inputRecDesc.length];
            for (i = 0; i < this.inputRecDesc.length; ++i) {
                this.tAccess[i] = new FrameTupleAccessor(this.inputRecDesc[i]);
            }
            this.outputAppender = new FrameTupleAppender((IFrame)new VSizeFrame((IHyracksFrameMgrContext)ctx));
        }

        public void open() throws HyracksDataException {
        }

        public void nextFrame(ByteBuffer buffer) throws HyracksDataException {
            int w = this.subplans[this.inputIdx].getOutputWidth();
            FrameTupleAccessor accessor = this.tAccess[this.inputIdx];
            accessor.reset(buffer);
            for (int tIndex = 0; tIndex < accessor.getTupleCount(); ++tIndex) {
                this.tb.reset();
                TupleUtils.addFields((ArrayTupleBuilder)this.gbyTb, (ArrayTupleBuilder)this.tb);
                for (int f = 0; f < w; ++f) {
                    this.tb.addField((IFrameTupleAccessor)accessor, tIndex, f);
                }
                FrameUtils.appendToWriter((IFrameWriter)this.outputWriter, (IFrameTupleAppender)this.outputAppender, (int[])this.tb.getFieldEndOffsets(), (byte[])this.tb.getByteArray(), (int)0, (int)this.tb.getSize());
            }
        }

        public void close() throws HyracksDataException {
            this.outputAppender.write(this.outputWriter, true);
        }

        public void setInputIdx(int inputIdx) {
            this.inputIdx = inputIdx;
        }

        public ArrayTupleBuilder getGroupByTupleBuilder() {
            return this.gbyTb;
        }

        public void fail() throws HyracksDataException {
        }

        public void flush() throws HyracksDataException {
            this.outputAppender.flush(this.outputWriter);
        }
    }
}

