/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.dataflow;

import java.nio.ByteBuffer;
import org.apache.hyracks.api.com.job.profiling.counters.Counter;
import org.apache.hyracks.api.comm.FrameHelper;
import org.apache.hyracks.api.comm.IFrameWriter;
import org.apache.hyracks.api.context.IHyracksTaskContext;
import org.apache.hyracks.api.dataflow.ITimedWriter;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.profiling.IOperatorStats;
import org.apache.hyracks.api.job.profiling.IStatsCollector;
import org.apache.hyracks.api.job.profiling.NoOpOperatorStats;
import org.apache.hyracks.api.job.profiling.OperatorStats;
import org.apache.hyracks.api.job.profiling.counters.ICounter;
import org.apache.hyracks.api.util.HyracksRunnable;
import org.apache.hyracks.api.util.HyracksThrowingConsumer;
import org.apache.hyracks.util.IntSerDeUtils;

public class ProfiledFrameWriter
implements ITimedWriter {
    private final IFrameWriter writer;
    protected IOperatorStats upstreamStats = NoOpOperatorStats.INSTANCE;
    private int minSz = Integer.MAX_VALUE;
    private int maxSz = -1;
    private long avgSz;
    private ICounter totalTime;

    public ProfiledFrameWriter(IFrameWriter writer) {
        this.writer = writer;
        this.totalTime = new Counter("totalTime");
    }

    @Override
    public void setUpstreamStats(IOperatorStats stats) {
        this.upstreamStats = stats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void timeMethod(HyracksRunnable r, ICounter c) throws HyracksDataException {
        long nt = 0L;
        try {
            nt = System.nanoTime();
            r.run();
        }
        finally {
            c.update(System.nanoTime() - nt);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void timeMethod(HyracksThrowingConsumer<ByteBuffer> c, ByteBuffer buffer) throws HyracksDataException {
        long nt = 0L;
        try {
            nt = System.nanoTime();
            c.accept(buffer);
        }
        finally {
            this.totalTime.update(System.nanoTime() - nt);
        }
    }

    @Override
    public final void open() throws HyracksDataException {
        ProfiledFrameWriter.timeMethod(this.writer::open, this.totalTime);
    }

    private void updateTupleStats(ByteBuffer buffer) {
        int tupleCountOffset = FrameHelper.getTupleCountOffset(buffer.limit());
        int tupleCount = IntSerDeUtils.getInt((byte[])buffer.array(), (int)tupleCountOffset);
        ICounter tupleCounter = this.upstreamStats.getTupleCounter();
        long prevCount = tupleCounter.get();
        for (int i = 0; i < tupleCount; ++i) {
            int tupleLen = this.getTupleLength(i, tupleCountOffset, buffer);
            if (this.maxSz < tupleLen) {
                this.maxSz = tupleLen;
            }
            if (this.minSz > tupleLen) {
                this.minSz = tupleLen;
            }
            long prev = this.avgSz * prevCount;
            this.avgSz = (prev + (long)tupleLen) / (prevCount + 1L);
            ++prevCount;
        }
        this.upstreamStats.getMaxTupleSz().set(this.maxSz);
        this.upstreamStats.getMinTupleSz().set(this.minSz);
        this.upstreamStats.getAverageTupleSz().set(this.avgSz);
        tupleCounter.update(tupleCount);
    }

    @Override
    public final void nextFrame(ByteBuffer buffer) throws HyracksDataException {
        this.updateTupleStats(buffer);
        this.timeMethod(this.writer::nextFrame, buffer);
    }

    @Override
    public final void flush() throws HyracksDataException {
        ProfiledFrameWriter.timeMethod(this.writer::flush, this.totalTime);
    }

    @Override
    public final void fail() throws HyracksDataException {
        ProfiledFrameWriter.timeMethod(this.writer::fail, this.totalTime);
    }

    @Override
    public void close() throws HyracksDataException {
        ProfiledFrameWriter.timeMethod(this.writer::close, this.totalTime);
    }

    private int getTupleStartOffset(int tupleIndex, int tupleCountOffset, ByteBuffer buffer) {
        return tupleIndex == 0 ? 5 : IntSerDeUtils.getInt((byte[])buffer.array(), (int)(tupleCountOffset - 4 * tupleIndex));
    }

    private int getTupleEndOffset(int tupleIndex, int tupleCountOffset, ByteBuffer buffer) {
        return IntSerDeUtils.getInt((byte[])buffer.array(), (int)(tupleCountOffset - 4 * (tupleIndex + 1)));
    }

    public int getTupleLength(int tupleIndex, int tupleCountOffset, ByteBuffer buffer) {
        return this.getTupleEndOffset(tupleIndex, tupleCountOffset, buffer) - this.getTupleStartOffset(tupleIndex, tupleCountOffset, buffer);
    }

    public static IFrameWriter time(IFrameWriter writer, IHyracksTaskContext ctx, String name) throws HyracksDataException {
        if (!(writer instanceof ProfiledFrameWriter)) {
            IStatsCollector statsCollector = ctx.getStatsCollector();
            OperatorStats stats = new OperatorStats(name, "ODID:-1");
            statsCollector.add(stats);
            return new ProfiledFrameWriter(writer);
        }
        return writer;
    }

    @Override
    public long getTotalTime() {
        return this.totalTime.get();
    }
}

