/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.api.job;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.hyracks.api.dataflow.ActivityId;
import org.apache.hyracks.api.dataflow.ConnectorDescriptorId;
import org.apache.hyracks.api.dataflow.IActivity;
import org.apache.hyracks.api.dataflow.IConnectorDescriptor;
import org.apache.hyracks.api.dataflow.connectors.IConnectorPolicyAssignmentPolicy;
import org.apache.hyracks.api.dataflow.value.RecordDescriptor;
import org.apache.hyracks.api.job.ActivityClusterGraph;
import org.apache.hyracks.api.job.ActivityClusterId;

public class ActivityCluster
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ActivityClusterGraph acg;
    private final ActivityClusterId id;
    private final List<IActivity> roots;
    private final Map<ActivityId, IActivity> activities;
    private final Map<ConnectorDescriptorId, IConnectorDescriptor> connectors;
    private final Map<ConnectorDescriptorId, RecordDescriptor> connectorRecordDescriptorMap;
    private final Map<ActivityId, List<IConnectorDescriptor>> activityInputMap;
    private final Map<ActivityId, List<IConnectorDescriptor>> activityOutputMap;
    private final Map<ConnectorDescriptorId, Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>> connectorActivityMap;
    private final Map<ActivityId, Set<ActivityId>> blocked2blockerMap;
    private final List<ActivityCluster> dependencies;
    private IConnectorPolicyAssignmentPolicy cpap;

    public ActivityCluster(ActivityClusterGraph acg, ActivityClusterId id) {
        this.acg = acg;
        this.id = id;
        this.roots = new ArrayList<IActivity>();
        this.activities = new HashMap<ActivityId, IActivity>();
        this.connectors = new HashMap<ConnectorDescriptorId, IConnectorDescriptor>();
        this.connectorRecordDescriptorMap = new HashMap<ConnectorDescriptorId, RecordDescriptor>();
        this.activityInputMap = new HashMap<ActivityId, List<IConnectorDescriptor>>();
        this.activityOutputMap = new HashMap<ActivityId, List<IConnectorDescriptor>>();
        this.connectorActivityMap = new HashMap<ConnectorDescriptorId, Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>>();
        this.blocked2blockerMap = new HashMap<ActivityId, Set<ActivityId>>();
        this.dependencies = new ArrayList<ActivityCluster>();
    }

    public ActivityClusterGraph getActivityClusterGraph() {
        return this.acg;
    }

    public ActivityClusterId getId() {
        return this.id;
    }

    public void addRoot(IActivity activity) {
        this.roots.add(activity);
    }

    public void addActivity(IActivity activity) {
        this.activities.put(activity.getActivityId(), activity);
    }

    public void addConnector(IConnectorDescriptor connector) {
        this.connectors.put(connector.getConnectorId(), connector);
    }

    public void connect(IConnectorDescriptor connector, IActivity producerActivity, int producerPort, IActivity consumerActivity, int consumerPort, RecordDescriptor recordDescriptor) {
        if (!this.activities.containsKey(producerActivity.getActivityId()) || !this.activities.containsKey(consumerActivity.getActivityId())) {
            throw new IllegalStateException("Connected Activities belong to different Activity Clusters: " + producerActivity.getActivityId() + " and " + consumerActivity.getActivityId());
        }
        this.insertIntoIndexedMap(this.activityInputMap, consumerActivity.getActivityId(), consumerPort, connector);
        this.insertIntoIndexedMap(this.activityOutputMap, producerActivity.getActivityId(), producerPort, connector);
        this.connectorActivityMap.put(connector.getConnectorId(), (Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>)Pair.of((Object)Pair.of((Object)producerActivity, (Object)producerPort), (Object)Pair.of((Object)consumerActivity, (Object)consumerPort)));
        this.connectorRecordDescriptorMap.put(connector.getConnectorId(), recordDescriptor);
    }

    public List<IActivity> getRoots() {
        return this.roots;
    }

    public Map<ActivityId, IActivity> getActivityMap() {
        return this.activities;
    }

    public Map<ConnectorDescriptorId, IConnectorDescriptor> getConnectorMap() {
        return this.connectors;
    }

    public Map<ConnectorDescriptorId, RecordDescriptor> getConnectorRecordDescriptorMap() {
        return this.connectorRecordDescriptorMap;
    }

    public Map<ConnectorDescriptorId, Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>>> getConnectorActivityMap() {
        return this.connectorActivityMap;
    }

    public Map<ActivityId, List<IConnectorDescriptor>> getActivityInputMap() {
        return this.activityInputMap;
    }

    public Map<ActivityId, List<IConnectorDescriptor>> getActivityOutputMap() {
        return this.activityOutputMap;
    }

    public ActivityId getConsumerActivity(ConnectorDescriptorId cdId) {
        Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>> connEdge = this.connectorActivityMap.get(cdId);
        return ((IActivity)((Pair)connEdge.getRight()).getLeft()).getActivityId();
    }

    public ActivityId getProducerActivity(ConnectorDescriptorId cdId) {
        Pair<Pair<IActivity, Integer>, Pair<IActivity, Integer>> connEdge = this.connectorActivityMap.get(cdId);
        return ((IActivity)((Pair)connEdge.getLeft()).getLeft()).getActivityId();
    }

    public Map<ActivityId, Set<ActivityId>> getBlocked2BlockerMap() {
        return this.blocked2blockerMap;
    }

    public List<ActivityCluster> getDependencies() {
        return this.dependencies;
    }

    public IConnectorPolicyAssignmentPolicy getConnectorPolicyAssignmentPolicy() {
        return this.cpap;
    }

    public void setConnectorPolicyAssignmentPolicy(IConnectorPolicyAssignmentPolicy cpap) {
        this.cpap = cpap;
    }

    private <T> void extend(List<T> list, int index) {
        int n;
        for (int i = n = list.size(); i <= index; ++i) {
            list.add(null);
        }
    }

    private <K, V> void insertIntoIndexedMap(Map<K, List<V>> map, K key, int index, V value) {
        List<V> vList = map.get(key);
        if (vList == null) {
            vList = new ArrayList<V>();
            map.put(key, vList);
        }
        this.extend(vList, index);
        vList.set(index, value);
    }

    public JsonNode toJSON() {
        ObjectMapper om = new ObjectMapper();
        ArrayNode jans = om.createArrayNode();
        ObjectNode jac = om.createObjectNode();
        for (IActivity an : this.activities.values()) {
            Set<ActivityId> blockers;
            List<IConnectorDescriptor> outputs;
            ObjectNode jan = om.createObjectNode();
            jan.put("id", an.getActivityId().toString());
            jan.put("java-class", an.getClass().getName());
            List<IConnectorDescriptor> inputs = this.activityInputMap.get(an.getActivityId());
            if (inputs != null) {
                ArrayNode jInputs = om.createArrayNode();
                for (int i = 0; i < inputs.size(); ++i) {
                    ObjectNode jInput = om.createObjectNode();
                    jInput.put("input-port", i);
                    jInput.put("connector-id", inputs.get(i).getConnectorId().toString());
                    jInputs.add((JsonNode)jInput);
                }
                jan.set("inputs", (JsonNode)jInputs);
            }
            if ((outputs = this.activityOutputMap.get(an.getActivityId())) != null) {
                ArrayNode jOutputs = om.createArrayNode();
                for (int i = 0; i < outputs.size(); ++i) {
                    ObjectNode jOutput = om.createObjectNode();
                    jOutput.put("output-port", i);
                    jOutput.put("connector-id", outputs.get(i).getConnectorId().toString());
                    jOutputs.add((JsonNode)jOutput);
                }
                jan.set("outputs", (JsonNode)jOutputs);
            }
            if ((blockers = this.getBlocked2BlockerMap().get(an.getActivityId())) != null) {
                ArrayNode jDeps = om.createArrayNode();
                for (ActivityId blocker : blockers) {
                    jDeps.add(blocker.toString());
                }
                jan.set("depends-on", (JsonNode)jDeps);
            }
            jans.add((JsonNode)jan);
        }
        jac.set("activities", (JsonNode)jans);
        return jac;
    }
}

