/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.comm.channels;

import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayDeque;
import java.util.Queue;
import org.apache.hyracks.api.channels.IInputChannel;
import org.apache.hyracks.api.channels.IInputChannelMonitor;
import org.apache.hyracks.api.comm.IBufferAcceptor;
import org.apache.hyracks.api.comm.IChannelControlBlock;
import org.apache.hyracks.api.comm.ICloseableBufferAcceptor;
import org.apache.hyracks.api.context.IHyracksCommonContext;
import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.result.ResultSetId;
import org.apache.hyracks.comm.channels.IChannelConnectionFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResultNetworkInputChannel
implements IInputChannel {
    private static final Logger LOGGER = LogManager.getLogger();
    static final int INITIAL_MESSAGE_SIZE = 20;
    private final IChannelConnectionFactory netManager;
    private final SocketAddress remoteAddress;
    private final JobId jobId;
    private final ResultSetId resultSetId;
    private final int partition;
    private final Queue<ByteBuffer> fullQueue;
    private final int nBuffers;
    private IChannelControlBlock ccb;
    private IInputChannelMonitor monitor;
    private Object attachment;

    public ResultNetworkInputChannel(IChannelConnectionFactory netManager, SocketAddress remoteAddress, JobId jobId, ResultSetId resultSetId, int partition, int nBuffers) {
        this.netManager = netManager;
        this.remoteAddress = remoteAddress;
        this.jobId = jobId;
        this.resultSetId = resultSetId;
        this.partition = partition;
        this.fullQueue = new ArrayDeque<ByteBuffer>(nBuffers);
        this.nBuffers = nBuffers;
    }

    public void registerMonitor(IInputChannelMonitor monitor) {
        this.monitor = monitor;
    }

    public void setAttachment(Object attachment) {
        this.attachment = attachment;
    }

    public Object getAttachment() {
        return this.attachment;
    }

    public synchronized ByteBuffer getNextBuffer() {
        return this.fullQueue.poll();
    }

    public void recycleBuffer(ByteBuffer buffer) {
        buffer.clear();
        this.ccb.getReadInterface().getEmptyBufferAcceptor().accept(buffer);
    }

    public void open(IHyracksCommonContext ctx) throws HyracksDataException {
        try {
            this.ccb = this.netManager.connect(this.remoteAddress);
        }
        catch (Exception e) {
            throw HyracksDataException.create((Throwable)e);
        }
        this.ccb.getReadInterface().setFullBufferAcceptor((ICloseableBufferAcceptor)new ReadFullBufferAcceptor());
        this.ccb.getWriteInterface().setEmptyBufferAcceptor((IBufferAcceptor)new WriteEmptyBufferAcceptor());
        for (int i = 0; i < this.nBuffers; ++i) {
            this.ccb.getReadInterface().getEmptyBufferAcceptor().accept(ctx.allocateFrame());
        }
        ByteBuffer writeBuffer = ByteBuffer.allocate(20);
        writeBuffer.putLong(this.jobId.getId());
        writeBuffer.putLong(this.resultSetId.getId());
        writeBuffer.putInt(this.partition);
        writeBuffer.flip();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Sending partition request for JobId: " + this.jobId + " partition: " + this.partition + " on channel: " + this.ccb);
        }
        this.ccb.getWriteInterface().getFullBufferAcceptor().accept(writeBuffer);
        this.ccb.getWriteInterface().getFullBufferAcceptor().close();
    }

    public void close() throws HyracksDataException {
    }

    public void fail() {
        this.ccb.getWriteInterface().getFullBufferAcceptor().error(1);
    }

    private class ReadFullBufferAcceptor
    implements ICloseableBufferAcceptor {
        private ReadFullBufferAcceptor() {
        }

        public void accept(ByteBuffer buffer) {
            ResultNetworkInputChannel.this.fullQueue.add(buffer);
            ResultNetworkInputChannel.this.monitor.notifyDataAvailability((IInputChannel)ResultNetworkInputChannel.this, 1);
        }

        public void close() {
            ResultNetworkInputChannel.this.monitor.notifyEndOfStream((IInputChannel)ResultNetworkInputChannel.this);
        }

        public void error(int ecode) {
            ResultNetworkInputChannel.this.monitor.notifyFailure((IInputChannel)ResultNetworkInputChannel.this, ecode);
        }
    }

    private class WriteEmptyBufferAcceptor
    implements IBufferAcceptor {
        private WriteEmptyBufferAcceptor() {
        }

        public void accept(ByteBuffer buffer) {
        }
    }
}

