/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.storage.am.lsm.btree.impls;

import org.apache.hyracks.api.exceptions.HyracksDataException;
import org.apache.hyracks.dataflow.common.data.accessors.ITupleReference;
import org.apache.hyracks.storage.am.btree.impls.BTree;
import org.apache.hyracks.storage.am.btree.impls.BatchPredicate;
import org.apache.hyracks.storage.am.common.api.ITreeIndexCursor;
import org.apache.hyracks.storage.am.lsm.btree.impls.LSMBTreePointSearchCursor;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMComponent;
import org.apache.hyracks.storage.am.lsm.common.api.ILSMIndexOperationContext;

public class LSMBTreeBatchPointSearchCursor
extends LSMBTreePointSearchCursor {
    public LSMBTreeBatchPointSearchCursor(ILSMIndexOperationContext opCtx) {
        super(opCtx);
    }

    @Override
    public boolean doHasNext() throws HyracksDataException {
        BatchPredicate batchPred = (BatchPredicate)this.predicate;
        while (!this.foundTuple && batchPred.hasNext()) {
            batchPred.next();
            if (this.foundIn >= 0) {
                if (((ILSMComponent)this.operationalComponents.get(this.foundIn)).getType() == ILSMComponent.LSMComponentType.MEMORY) {
                    this.btreeCursors[this.foundIn].close();
                }
                this.foundIn = -1;
            }
            this.foundTuple = super.doHasNext();
        }
        return this.foundTuple;
    }

    @Override
    public void doNext() throws HyracksDataException {
        this.foundTuple = false;
    }

    @Override
    protected ITreeIndexCursor createCursor(ILSMComponent.LSMComponentType type, BTree.BTreeAccessor btreeAccessor) {
        return btreeAccessor.createPointCursor(false, true);
    }

    @Override
    protected boolean isSearchCandidate(int componentIndex) throws HyracksDataException {
        if (!super.isSearchCandidate(componentIndex)) {
            return false;
        }
        ITupleReference minFilterKey = this.predicate.getMinFilterTuple();
        ITupleReference maxFileterKey = this.predicate.getMaxFilterTuple();
        boolean filtered = minFilterKey != null && maxFileterKey != null;
        return !filtered || ((ILSMComponent)this.operationalComponents.get(componentIndex)).getLSMComponentFilter().satisfy(minFilterKey, maxFileterKey, this.opCtx.getFilterCmp());
    }

    public int getKeyIndex() {
        return ((BatchPredicate)this.predicate).getKeyIndex();
    }
}

