/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hyracks.control.cc.work;

import java.util.ArrayList;
import java.util.List;
import org.apache.hyracks.api.exceptions.HyracksException;
import org.apache.hyracks.api.job.JobId;
import org.apache.hyracks.api.job.JobStatus;
import org.apache.hyracks.control.cc.job.IJobManager;
import org.apache.hyracks.control.cc.job.JobRun;
import org.apache.hyracks.control.common.work.AbstractWork;
import org.apache.hyracks.control.common.work.IResultCallback;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class JobCleanupWork
extends AbstractWork {
    private static final Logger LOGGER = LogManager.getLogger();
    private final IJobManager jobManager;
    private final JobId jobId;
    private final JobStatus status;
    private final List<Exception> exceptions;
    private final IResultCallback<Void> callback;

    public JobCleanupWork(IJobManager jobManager, JobId jobId, JobStatus status, List<Exception> exceptions, IResultCallback<Void> callback) {
        this.jobManager = jobManager;
        this.jobId = jobId;
        this.status = status;
        this.exceptions = exceptions;
        this.callback = callback;
    }

    public void run() {
        LOGGER.info("cleaning up {} on NCs, status={}", (Object)this.jobId, (Object)this.status);
        JobRun jobRun = this.jobManager.get(this.jobId);
        if (jobRun == null) {
            LOGGER.debug("ignoring cleanup for unknown {}", (Object)this.jobId);
            return;
        }
        try {
            this.jobManager.prepareComplete(jobRun, this.status, this.exceptions);
            this.callback.setValue(null);
        }
        catch (HyracksException e) {
            JobRun run = this.jobManager.get(this.jobId);
            ArrayList<Exception> completionException = new ArrayList<Exception>();
            if (run.getExceptions() != null && !run.getExceptions().isEmpty()) {
                completionException.addAll(run.getExceptions());
            }
            completionException.add(0, (Exception)((Object)e));
            run.setStatus(JobStatus.FAILURE, completionException);
            this.callback.setException((Exception)((Object)e));
        }
    }

    public String toString() {
        return this.getName() + ": JobId@" + this.jobId + " Status@" + this.status + (String)(this.exceptions == null ? "" : " Exceptions@" + this.exceptions);
    }
}

