/*
 * Decompiled with CFR 0.152.
 */
package com.teradata.tpcds.row.generator;

import com.teradata.tpcds.JoinKeyUtils;
import com.teradata.tpcds.Nulls;
import com.teradata.tpcds.Permutations;
import com.teradata.tpcds.Scaling;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.SlowlyChangingDimensionUtils;
import com.teradata.tpcds.Table;
import com.teradata.tpcds.generator.StoreSalesGeneratorColumn;
import com.teradata.tpcds.random.RandomValueGenerator;
import com.teradata.tpcds.row.StoreSalesRow;
import com.teradata.tpcds.row.TableRow;
import com.teradata.tpcds.row.generator.AbstractRowGenerator;
import com.teradata.tpcds.row.generator.RowGenerator;
import com.teradata.tpcds.row.generator.RowGeneratorResult;
import com.teradata.tpcds.row.generator.StoreReturnsRowGenerator;
import com.teradata.tpcds.type.Pricing;
import java.util.ArrayList;

public class StoreSalesRowGenerator
extends AbstractRowGenerator {
    private static final int SR_RETURN_PCT = 10;
    private int[] itemPermutation;
    private int remainingLineItems = 0;
    private OrderInfo orderInfo = new OrderInfo();
    private int itemIndex;

    public StoreSalesRowGenerator() {
        super(Table.STORE_SALES);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        int itemCount = (int)session.getScaling().getIdCount(Table.ITEM);
        if (this.itemPermutation == null) {
            this.itemPermutation = Permutations.makePermutation(itemCount, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_PERMUTATION));
        }
        Scaling scaling = session.getScaling();
        if (this.remainingLineItems == 0) {
            this.orderInfo = this.generateOrderInfo(rowNumber, session);
            this.remainingLineItems = RandomValueGenerator.generateUniformRandomInt(8, 16, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_TICKET_NUMBER));
            this.itemIndex = RandomValueGenerator.generateUniformRandomInt(1, (int)scaling.getIdCount(Table.ITEM), this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_SOLD_ITEM_SK));
        }
        long nullBitMap = Nulls.createNullBitMap(Table.STORE_SALES, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_NULLS));
        if (++this.itemIndex > itemCount) {
            this.itemIndex = 1;
        }
        long ssSoldItemSk = SlowlyChangingDimensionUtils.matchSurrogateKey(Permutations.getPermutationEntry(this.itemPermutation, this.itemIndex), this.orderInfo.getSsSoldDateSk(), Table.ITEM, scaling);
        long ssSoldPromoSk = JoinKeyUtils.generateJoinKey(StoreSalesGeneratorColumn.SS_SOLD_PROMO_SK, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_SOLD_PROMO_SK), Table.PROMOTION, 1L, scaling);
        Pricing ssPricing = Pricing.generatePricingForSalesTable(StoreSalesGeneratorColumn.SS_PRICING, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_PRICING));
        StoreSalesRow storeSalesRow = new StoreSalesRow(nullBitMap, this.orderInfo.getSsSoldDateSk(), this.orderInfo.getSsSoldTimeSk(), ssSoldItemSk, this.orderInfo.getSsSoldCustomerSk(), this.orderInfo.getSsSoldCdemoSk(), this.orderInfo.getSsSoldHdemoSk(), this.orderInfo.getSsSoldAddrSk(), this.orderInfo.getSsSoldStoreSk(), ssSoldPromoSk, this.orderInfo.getSsTicketNumber(), ssPricing);
        ArrayList<TableRow> generatedRows = new ArrayList<TableRow>(2);
        generatedRows.add(storeSalesRow);
        int randomInt = RandomValueGenerator.generateUniformRandomInt(0, 99, this.getRandomNumberStream(StoreSalesGeneratorColumn.SR_IS_RETURNED));
        if (!(randomInt >= 10 || session.generateOnlyOneTable() && session.getOnlyTableToGenerate() == Table.STORE_SALES)) {
            generatedRows.add(((StoreReturnsRowGenerator)childRowGenerator).generateRow(session, storeSalesRow));
        }
        --this.remainingLineItems;
        return new RowGeneratorResult(generatedRows, this.isLastRowInOrder());
    }

    public OrderInfo generateOrderInfo(long rowNumber, Session session) {
        Scaling scaling = session.getScaling();
        long ssSoldStoreSk = JoinKeyUtils.generateJoinKey(StoreSalesGeneratorColumn.SS_SOLD_STORE_SK, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_SOLD_STORE_SK), Table.STORE, 1L, scaling);
        long ssSoldTimeSk = JoinKeyUtils.generateJoinKey(StoreSalesGeneratorColumn.SS_SOLD_TIME_SK, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_SOLD_TIME_SK), Table.TIME_DIM, 1L, scaling);
        long ssSoldDateSk = JoinKeyUtils.generateJoinKey(StoreSalesGeneratorColumn.SS_SOLD_DATE_SK, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_SOLD_DATE_SK), Table.DATE_DIM, 1L, scaling);
        long ssSoldCustomerSk = JoinKeyUtils.generateJoinKey(StoreSalesGeneratorColumn.SS_SOLD_CUSTOMER_SK, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_SOLD_CUSTOMER_SK), Table.CUSTOMER, 1L, scaling);
        long ssSoldCdemoSk = JoinKeyUtils.generateJoinKey(StoreSalesGeneratorColumn.SS_SOLD_CDEMO_SK, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_SOLD_CDEMO_SK), Table.CUSTOMER_DEMOGRAPHICS, 1L, scaling);
        long ssSoldHdemoSk = JoinKeyUtils.generateJoinKey(StoreSalesGeneratorColumn.SS_SOLD_HDEMO_SK, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_SOLD_HDEMO_SK), Table.HOUSEHOLD_DEMOGRAPHICS, 1L, scaling);
        long ssSoldAddrSk = JoinKeyUtils.generateJoinKey(StoreSalesGeneratorColumn.SS_SOLD_ADDR_SK, this.getRandomNumberStream(StoreSalesGeneratorColumn.SS_SOLD_ADDR_SK), Table.CUSTOMER_ADDRESS, 1L, scaling);
        long ssTicketNumber = rowNumber;
        return new OrderInfo(ssSoldStoreSk, ssSoldTimeSk, ssSoldDateSk, ssSoldCustomerSk, ssSoldCdemoSk, ssSoldHdemoSk, ssSoldAddrSk, ssTicketNumber);
    }

    private boolean isLastRowInOrder() {
        return this.remainingLineItems == 0;
    }

    private class OrderInfo {
        private final long ssSoldStoreSk;
        private final long ssSoldTimeSk;
        private final long ssSoldDateSk;
        private final long ssSoldCustomerSk;
        private final long ssSoldCdemoSk;
        private final long ssSoldHdemoSk;
        private final long ssSoldAddrSk;
        private final long ssTicketNumber;

        public OrderInfo(long ssSoldStoreSk, long ssSoldTimeSk, long ssSoldDateSk, long ssSoldCustomerSk, long ssSoldCdemoSk, long ssSoldHdemoSk, long ssSoldAddrSk, long ssTicketNumber) {
            this.ssSoldStoreSk = ssSoldStoreSk;
            this.ssSoldTimeSk = ssSoldTimeSk;
            this.ssSoldDateSk = ssSoldDateSk;
            this.ssSoldCustomerSk = ssSoldCustomerSk;
            this.ssSoldCdemoSk = ssSoldCdemoSk;
            this.ssSoldHdemoSk = ssSoldHdemoSk;
            this.ssSoldAddrSk = ssSoldAddrSk;
            this.ssTicketNumber = ssTicketNumber;
        }

        public OrderInfo() {
            this(0L, 0L, 0L, 0L, 0L, 0L, 0L, 0L);
        }

        public long getSsTicketNumber() {
            return this.ssTicketNumber;
        }

        public long getSsSoldStoreSk() {
            return this.ssSoldStoreSk;
        }

        public long getSsSoldTimeSk() {
            return this.ssSoldTimeSk;
        }

        public long getSsSoldDateSk() {
            return this.ssSoldDateSk;
        }

        public long getSsSoldCustomerSk() {
            return this.ssSoldCustomerSk;
        }

        public long getSsSoldCdemoSk() {
            return this.ssSoldCdemoSk;
        }

        public long getSsSoldHdemoSk() {
            return this.ssSoldHdemoSk;
        }

        public long getSsSoldAddrSk() {
            return this.ssSoldAddrSk;
        }
    }
}

