/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.storage;

import com.google.cloud.storage.Throughput;
import com.google.cloud.storage.ThroughputMovingWindow;
import com.google.common.base.MoreObjects;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.WritableByteChannel;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Objects;
import java.util.logging.Logger;

interface ThroughputSink {
    public void recordThroughput(Record var1);

    public WritableByteChannel decorate(WritableByteChannel var1);

    public static void computeThroughput(Clock clock, ThroughputSink sink, long numBytes, IO io) throws IOException {
        boolean exception = false;
        Instant begin = clock.instant();
        try {
            io.apply();
        }
        catch (IOException e) {
            exception = true;
            throw e;
        }
        finally {
            Instant end = clock.instant();
            Record record = Record.of(numBytes, begin, end, exception);
            sink.recordThroughput(record);
        }
    }

    public static ThroughputSink logged(String prefix, Clock clock) {
        return new LoggedThroughputSink(prefix, clock);
    }

    public static ThroughputSink windowed(ThroughputMovingWindow w, Clock clock) {
        return new ThroughputMovingWindowThroughputSink(w, clock);
    }

    public static ThroughputSink tee(ThroughputSink a, ThroughputSink b) {
        return new TeeThroughputSink(a, b);
    }

    public static ThroughputSink nullSink() {
        return NullThroughputSink.INSTANCE;
    }

    @FunctionalInterface
    public static interface IO {
        public void apply() throws IOException;
    }

    public static final class Record {
        private final long numBytes;
        private final Instant begin;
        private final Instant end;
        private final boolean exception;

        private Record(long numBytes, Instant begin, Instant end, boolean exception) {
            this.numBytes = numBytes;
            this.begin = begin;
            this.end = end;
            this.exception = exception;
        }

        public long getNumBytes() {
            return this.numBytes;
        }

        public Instant getBegin() {
            return this.begin;
        }

        public Instant getEnd() {
            return this.end;
        }

        public Duration getDuration() {
            return Duration.between(this.begin, this.end);
        }

        public boolean isException() {
            return this.exception;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Record)) {
                return false;
            }
            Record record = (Record)o;
            return this.numBytes == record.numBytes && this.exception == record.exception && Objects.equals(this.begin, record.begin) && Objects.equals(this.end, record.end);
        }

        public int hashCode() {
            return Objects.hash(this.numBytes, this.begin, this.end, this.exception);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("numBytes", this.numBytes).add("begin", (Object)this.begin).add("end", (Object)this.end).add("exception", this.exception).toString();
        }

        public static Record of(long numBytes, Instant begin, Instant end, boolean exception) {
            return new Record(numBytes, begin, end, exception);
        }
    }

    public static final class LoggedThroughputSink
    implements ThroughputSink {
        private static final Logger LOGGER = Logger.getLogger(ThroughputSink.class.getName());
        private final String prefix;
        private final Clock clock;
        private static final double MiB = 9.5367431640625E-7;

        private LoggedThroughputSink(String prefix, Clock clock) {
            this.prefix = prefix;
            this.clock = clock;
        }

        @Override
        public void recordThroughput(Record r) {
            LOGGER.info(() -> String.format("{%s} (%01.03f MiB/s) %s", this.prefix, (double)r.numBytes * 9.5367431640625E-7 / ((double)Duration.between(r.getBegin(), r.getEnd()).toMillis() / 1000.0), r));
        }

        @Override
        public WritableByteChannel decorate(WritableByteChannel wbc) {
            return new ThroughputRecordingWritableByteChannel(wbc, this, this.clock);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("prefix", (Object)this.prefix).add("clock", (Object)this.clock).toString();
        }
    }

    public static final class ThroughputMovingWindowThroughputSink
    implements ThroughputSink {
        private final ThroughputMovingWindow w;
        private final Clock clock;

        private ThroughputMovingWindowThroughputSink(ThroughputMovingWindow w, Clock clock) {
            this.w = w;
            this.clock = clock;
        }

        @Override
        public synchronized void recordThroughput(Record r) {
            this.w.add(r.end, Throughput.of(r.getNumBytes(), r.getDuration()));
        }

        @Override
        public WritableByteChannel decorate(WritableByteChannel wbc) {
            return new ThroughputRecordingWritableByteChannel(wbc, this, this.clock);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("w", (Object)this.w).add("clock", (Object)this.clock).toString();
        }
    }

    public static final class TeeThroughputSink
    implements ThroughputSink {
        private final ThroughputSink a;
        private final ThroughputSink b;

        private TeeThroughputSink(ThroughputSink a, ThroughputSink b) {
            this.a = a;
            this.b = b;
        }

        @Override
        public void recordThroughput(Record r) {
            this.a.recordThroughput(r);
            this.b.recordThroughput(r);
        }

        @Override
        public WritableByteChannel decorate(WritableByteChannel wbc) {
            return this.b.decorate(this.a.decorate(wbc));
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("a", (Object)this.a).add("b", (Object)this.b).toString();
        }
    }

    public static final class NullThroughputSink
    implements ThroughputSink {
        private static final NullThroughputSink INSTANCE = new NullThroughputSink();

        private NullThroughputSink() {
        }

        @Override
        public void recordThroughput(Record r) {
        }

        @Override
        public WritableByteChannel decorate(WritableByteChannel wbc) {
            return wbc;
        }
    }

    public static final class ThroughputRecordingWritableByteChannel
    implements WritableByteChannel {
        private final WritableByteChannel delegate;
        private final ThroughputSink sink;
        private final Clock clock;

        private ThroughputRecordingWritableByteChannel(WritableByteChannel delegate, ThroughputSink sink, Clock clock) {
            this.delegate = delegate;
            this.sink = sink;
            this.clock = clock;
        }

        @Override
        public int write(ByteBuffer src) throws IOException {
            boolean exception = false;
            int remaining = src.remaining();
            Instant begin = this.clock.instant();
            try {
                int n = this.delegate.write(src);
                return n;
            }
            catch (IOException e) {
                exception = true;
                throw e;
            }
            finally {
                Instant end = this.clock.instant();
                Record record = Record.of(remaining - src.remaining(), begin, end, exception);
                this.sink.recordThroughput(record);
            }
        }

        @Override
        public boolean isOpen() {
            return this.delegate.isOpen();
        }

        @Override
        public void close() throws IOException {
            this.delegate.close();
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("delegate", (Object)this.delegate).add("sink", (Object)this.sink).add("clock", (Object)this.clock).toString();
        }
    }
}

