/*
 * Decompiled with CFR 0.152.
 */
package org.apache.asterix.jdbc.core;

import java.util.Objects;
import org.apache.asterix.jdbc.core.ADBDatatype;

public class ADBColumn {
    private final String name;
    private final ADBDatatype type;
    private final boolean optional;

    public ADBColumn(String name, ADBDatatype type, boolean optional) {
        this.name = Objects.requireNonNull(name);
        this.type = Objects.requireNonNull(type);
        this.optional = optional || type.isNullOrMissing() || type == ADBDatatype.ANY;
    }

    public String getName() {
        return this.name;
    }

    public ADBDatatype getType() {
        return this.type;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public String toString() {
        return String.format("%s:%s%s", this.name, this.type.getTypeName(), this.optional ? "?" : "");
    }
}

