/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.common.builder;

import java.util.Vector;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.intf.AxiomElement;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.common.builder.SOAPBuilderHelper;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12FaultCode;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12FaultDetail;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12FaultNode;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12FaultReason;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12FaultRole;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12FaultSubCode;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12FaultText;
import org.apache.axiom.soap.impl.intf.soap12.AxiomSOAP12FaultValue;

public class SOAP12BuilderHelper
extends SOAPBuilderHelper {
    private boolean codePresent = false;
    private boolean reasonPresent = false;
    private boolean nodePresent = false;
    private boolean rolePresent = false;
    private boolean detailPresent = false;
    private boolean subcodeValuePresent = false;
    private boolean subSubcodePresent = false;
    private boolean valuePresent = false;
    private boolean subcodePresent = false;
    private boolean codeprocessing = false;
    private boolean subCodeProcessing = false;
    private boolean reasonProcessing = false;
    private boolean processingDetailElements = false;
    private Vector<String> detailElementNames;

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    public Class<? extends AxiomElement> handleEvent(OMElement parent, int elementLevel, String namespaceURI, String localName) throws SOAPProcessingException {
        void var5_18;
        Object var5_5 = null;
        if (elementLevel == 4) {
            if (localName.equals("Code")) {
                if (this.codePresent) {
                    throw new SOAPProcessingException("Multiple Code element encountered");
                }
                Class<AxiomSOAP12FaultCode> clazz = AxiomSOAP12FaultCode.class;
                this.codePresent = true;
                this.codeprocessing = true;
                return var5_18;
            }
            if (localName.equals("Reason")) {
                if (!this.codeprocessing && !this.subCodeProcessing) {
                    if (!this.codePresent) throw new SOAPProcessingException("Wrong element order encountred at " + localName);
                    if (this.reasonPresent) {
                        throw new SOAPProcessingException("Multiple Reason Element encountered");
                    }
                    Class<AxiomSOAP12FaultReason> clazz = AxiomSOAP12FaultReason.class;
                    this.reasonPresent = true;
                    this.reasonProcessing = true;
                    return var5_18;
                }
                if (!this.codeprocessing) throw new SOAPProcessingException("A subcode doesn't have a Value");
                throw new SOAPProcessingException("Code doesn't have a value");
            }
            if (localName.equals("Node")) {
                if (this.reasonProcessing) throw new SOAPProcessingException("Reason element Should have a text");
                if (!this.reasonPresent) throw new SOAPProcessingException("wrong element order encountered at " + localName);
                if (this.rolePresent) throw new SOAPProcessingException("wrong element order encountered at " + localName);
                if (this.detailPresent) throw new SOAPProcessingException("wrong element order encountered at " + localName);
                if (this.nodePresent) {
                    throw new SOAPProcessingException("Multiple Node element encountered");
                }
                Class<AxiomSOAP12FaultNode> clazz = AxiomSOAP12FaultNode.class;
                this.nodePresent = true;
                return var5_18;
            }
            if (localName.equals("Role")) {
                if (this.reasonProcessing) throw new SOAPProcessingException("Reason element should have a text");
                if (!this.reasonPresent) throw new SOAPProcessingException("Wrong element order encountered at " + localName);
                if (this.detailPresent) throw new SOAPProcessingException("Wrong element order encountered at " + localName);
                if (this.rolePresent) {
                    throw new SOAPProcessingException("Multiple Role element encountered");
                }
                Class<AxiomSOAP12FaultRole> clazz = AxiomSOAP12FaultRole.class;
                this.rolePresent = true;
                return var5_18;
            }
            if (!localName.equals("Detail")) throw new SOAPProcessingException(String.valueOf(localName) + " unsupported element in SOAPFault element");
            if (this.reasonProcessing) throw new SOAPProcessingException("Reason element should have a text");
            if (!this.reasonPresent) throw new SOAPProcessingException("wrong element order encountered at " + localName);
            if (this.detailPresent) {
                throw new SOAPProcessingException("Multiple detail element encountered");
            }
            Class<AxiomSOAP12FaultDetail> clazz = AxiomSOAP12FaultDetail.class;
            this.detailPresent = true;
            return var5_18;
        }
        if (elementLevel == 5) {
            if (parent.getLocalName().equals("Code")) {
                if (localName.equals("Value")) {
                    if (this.valuePresent) throw new SOAPProcessingException("Multiple value Encountered in code element");
                    Class<AxiomSOAP12FaultValue> clazz = AxiomSOAP12FaultValue.class;
                    this.valuePresent = true;
                    this.codeprocessing = false;
                    return var5_18;
                }
                if (!localName.equals("Subcode")) throw new SOAPProcessingException(String.valueOf(localName) + " is not supported inside the code element");
                if (this.subcodePresent) throw new SOAPProcessingException("multiple subcode Encountered in code element");
                if (!this.valuePresent) throw new SOAPProcessingException("Value should present before the subcode");
                Class<AxiomSOAP12FaultSubCode> clazz = AxiomSOAP12FaultSubCode.class;
                this.subcodePresent = true;
                this.subCodeProcessing = true;
                return var5_18;
            }
            if (parent.getLocalName().equals("Reason")) {
                if (!localName.equals("Text")) throw new SOAPProcessingException(String.valueOf(localName) + " is not supported inside the reason");
                Class<AxiomSOAP12FaultText> clazz = AxiomSOAP12FaultText.class;
                this.reasonProcessing = false;
                return var5_18;
            }
            if (!parent.getLocalName().equals("Detail")) throw new SOAPProcessingException(String.valueOf(parent.getLocalName()) + " should not have child element");
            Class<AxiomElement> clazz = AxiomElement.class;
            this.processingDetailElements = true;
            this.detailElementNames = new Vector();
            this.detailElementNames.add(localName);
            return var5_18;
        }
        if (elementLevel <= 5) return var5_18;
        if (parent.getLocalName().equals("Subcode")) {
            if (!localName.equals("Value")) {
                if (!localName.equals("Subcode")) throw new SOAPProcessingException(String.valueOf(localName) + " is not supported inside the subCode element");
                if (!this.subcodeValuePresent) throw new SOAPProcessingException("Value should present before the subcode");
                if (this.subSubcodePresent) throw new SOAPProcessingException("multiple subcode encountered");
                Class<AxiomSOAP12FaultSubCode> clazz = AxiomSOAP12FaultSubCode.class;
                this.subcodeValuePresent = false;
                this.subSubcodePresent = true;
                this.subCodeProcessing = true;
                return var5_18;
            }
            if (this.subcodeValuePresent) {
                throw new SOAPProcessingException("multiple subCode value encountered");
            }
            Class<AxiomSOAP12FaultValue> clazz = AxiomSOAP12FaultValue.class;
            this.subcodeValuePresent = true;
            this.subSubcodePresent = false;
            this.subCodeProcessing = false;
            return var5_18;
        }
        if (!this.processingDetailElements) throw new SOAPProcessingException(String.valueOf(parent.getLocalName()) + " should not have child at element level " + elementLevel);
        int detailElementLevel = 0;
        boolean localNameExist = false;
        int i = 0;
        while (i < this.detailElementNames.size()) {
            if (parent.getLocalName().equals(this.detailElementNames.get(i))) {
                localNameExist = true;
                detailElementLevel = i + 1;
            }
            ++i;
        }
        if (!localNameExist) return var5_18;
        this.detailElementNames.setSize(detailElementLevel);
        Class<AxiomElement> clazz = AxiomElement.class;
        this.detailElementNames.add(localName);
        return var5_18;
    }
}

