/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.stream.stax.push;

import java.io.IOException;
import java.io.StringWriter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.core.stream.StreamException;
import org.apache.axiom.core.stream.XmlHandler;
import org.apache.axiom.core.stream.serializer.Serializer;
import org.apache.axiom.core.stream.util.CharacterDataAccumulator;
import org.apache.axiom.ext.stax.datahandler.DataHandlerProvider;
import org.apache.axiom.ext.stax.datahandler.DataHandlerWriter;
import org.apache.axiom.om.impl.intf.TextContent;
import org.apache.axiom.util.stax.XMLStreamWriterUtils;

public class XMLStreamWriterHandler
implements XmlHandler {
    private final XMLStreamWriter writer;
    private DataHandlerWriter dataHandlerWriter;
    private final CharacterDataAccumulator buffer = new CharacterDataAccumulator();
    private boolean buffering;
    private String piTarget;

    public XMLStreamWriterHandler(XMLStreamWriter writer) {
        this.writer = writer;
    }

    public XMLStreamWriter getWriter() {
        return this.writer;
    }

    private String stopBuffering() {
        String content = this.buffer.toString();
        this.buffer.clear();
        this.buffering = false;
        return content;
    }

    @Override
    public void startDocument(String inputEncoding, String xmlVersion, String xmlEncoding, Boolean standalone) throws StreamException {
        try {
            if (xmlEncoding == null) {
                this.writer.writeStartDocument(xmlVersion);
            } else {
                this.writer.writeStartDocument(xmlEncoding, xmlVersion);
            }
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void startFragment() throws StreamException {
    }

    @Override
    public void processDocumentTypeDeclaration(String rootName, String publicId, String systemId, String internalSubset) throws StreamException {
        StringWriter sw = new StringWriter();
        Serializer serializer = new Serializer(sw);
        serializer.startFragment();
        serializer.processDocumentTypeDeclaration(rootName, publicId, systemId, internalSubset);
        serializer.completed();
        try {
            this.writer.writeDTD(sw.toString());
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void startElement(String namespaceURI, String localName, String prefix) throws StreamException {
        try {
            this.writer.writeStartElement(prefix, localName, namespaceURI);
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void processNamespaceDeclaration(String prefix, String namespaceURI) throws StreamException {
        try {
            if (prefix.length() != 0) {
                this.writer.writeNamespace(prefix, namespaceURI);
            } else {
                this.writer.writeDefaultNamespace(namespaceURI);
            }
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void processAttribute(String namespaceURI, String localName, String prefix, String value, String type, boolean specified) throws StreamException {
        try {
            this.writer.writeAttribute(prefix, namespaceURI, localName, value);
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void processAttribute(String name, String value, String type, boolean specified) throws StreamException {
        try {
            this.writer.writeAttribute(name, value);
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void attributesCompleted() throws StreamException {
    }

    @Override
    public void endElement() throws StreamException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void processCharacterData(Object data, boolean ignorable) throws StreamException {
        if (this.buffering) {
            this.buffer.append(data);
            return;
        }
        try {
            TextContent textContent;
            if (data instanceof TextContent && (textContent = (TextContent)data).isBinary()) {
                Object dataHandlerObject = textContent.getDataHandlerObject();
                if (dataHandlerObject instanceof DataHandlerProvider) {
                    this.getDataHandlerWriter().writeDataHandler((DataHandlerProvider)dataHandlerObject, textContent.getContentID(), textContent.isOptimize());
                } else {
                    this.getDataHandlerWriter().writeDataHandler(textContent.getDataHandler(), textContent.getContentID(), textContent.isOptimize());
                }
                return;
            }
            this.writer.writeCharacters(data.toString());
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
        catch (IOException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void startCDATASection() throws StreamException {
        this.buffering = true;
    }

    @Override
    public void endCDATASection() throws StreamException {
        try {
            this.writer.writeCData(this.stopBuffering());
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void startComment() throws StreamException {
        this.buffering = true;
    }

    @Override
    public void endComment() throws StreamException {
        try {
            this.writer.writeComment(this.stopBuffering());
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void startProcessingInstruction(String target) throws StreamException {
        this.buffering = true;
        this.piTarget = target;
    }

    @Override
    public void endProcessingInstruction() throws StreamException {
        try {
            this.writer.writeProcessingInstruction(this.piTarget + " ", this.stopBuffering());
            this.piTarget = null;
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }

    @Override
    public void processEntityReference(String name, String replacementText) throws StreamException {
        try {
            this.writer.writeEntityRef(name);
        }
        catch (XMLStreamException ex) {
            throw new StreamException(ex);
        }
    }

    private DataHandlerWriter getDataHandlerWriter() {
        if (this.dataHandlerWriter == null) {
            this.dataHandlerWriter = XMLStreamWriterUtils.getDataHandlerWriter((XMLStreamWriter)this.writer);
        }
        return this.dataHandlerWriter;
    }

    @Override
    public void completed() throws StreamException {
    }

    @Override
    public boolean drain() throws StreamException {
        return true;
    }
}

