/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.location.jclouds.pool;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.brooklyn.location.jclouds.templates.PortableTemplateBuilder;
import org.jclouds.compute.options.TemplateOptions;

public class ReusableMachineTemplate
extends PortableTemplateBuilder<ReusableMachineTemplate> {
    public static final String PREFIX = "brooklyn:template.";
    public static final String NAME_METADATA_KEY = "brooklyn:template.name";
    public static final String DESCRIPTION_METADATA_KEY = "brooklyn:template.name";
    public static final String HASH_METADATA_KEY = "brooklyn:template.hash";
    public static final String TEMPLATE_OWNER_METADATA_KEY = "brooklyn:template.owner";
    private String name = null;
    private String templateOwner = null;
    private String description = null;
    private boolean strict;

    public ReusableMachineTemplate() {
        this.strict = false;
    }

    public ReusableMachineTemplate(String name) {
        this.name(name);
    }

    public ReusableMachineTemplate name(String name) {
        this.name = name;
        this.strict = true;
        return this;
    }

    public ReusableMachineTemplate description(String description) {
        this.description = description;
        return this;
    }

    public ReusableMachineTemplate strict(boolean strict) {
        this.strict = strict;
        return this;
    }

    public ReusableMachineTemplate templateUnowned() {
        return this.templateOwner(null);
    }

    public ReusableMachineTemplate templateOwnedByMe() {
        return this.templateOwner(System.getProperty("user.name"));
    }

    public ReusableMachineTemplate templateOwner(String owner) {
        this.templateOwner = owner;
        return this;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getOwner() {
        return this.templateOwner;
    }

    public boolean isStrict() {
        return this.strict;
    }

    @Override
    public List<TemplateOptions> getAdditionalOptions() {
        ArrayList<TemplateOptions> result = new ArrayList<TemplateOptions>();
        result.addAll(super.getAdditionalOptions());
        if (this.isStrict()) {
            this.addStrictOptions(result);
        }
        return result;
    }

    @Override
    public List<TemplateOptions> getAdditionalOptionalOptions() {
        ArrayList<TemplateOptions> result = new ArrayList<TemplateOptions>();
        result.addAll(super.getAdditionalOptions());
        this.addStrictOptions(result);
        return result;
    }

    protected void addStrictOptions(List<TemplateOptions> result) {
        if (this.name != null) {
            result.add(TemplateOptions.Builder.userMetadata((String)"brooklyn:template.name", (String)this.name));
        }
        if (this.templateOwner != null) {
            result.add(TemplateOptions.Builder.userMetadata((String)TEMPLATE_OWNER_METADATA_KEY, (String)this.templateOwner));
        }
    }

    public Map<String, String> getUserMetadata(boolean includeOptional) {
        return ImmutableMap.copyOf((Map)this.computeAggregatedOptions(includeOptional).getUserMetadata());
    }

    public Set<String> getTags(boolean includeOptional) {
        return ImmutableSet.copyOf((Collection)this.computeAggregatedOptions(includeOptional).getTags());
    }

    public ReusableMachineTemplate tag(String tag) {
        return this.tags(tag);
    }

    public ReusableMachineTemplate tags(String ... tags) {
        return (ReusableMachineTemplate)this.addOptions(TemplateOptions.Builder.tags(Arrays.asList(tags)));
    }

    public ReusableMachineTemplate metadata(String key, String value) {
        return (ReusableMachineTemplate)this.addOptions(TemplateOptions.Builder.userMetadata((String)key, (String)value));
    }

    public ReusableMachineTemplate metadata(Map<String, String> m) {
        return (ReusableMachineTemplate)this.addOptions(TemplateOptions.Builder.userMetadata(m));
    }

    public ReusableMachineTemplate tagOptional(String tag) {
        return this.tagsOptional(tag);
    }

    public ReusableMachineTemplate tagsOptional(String ... tags) {
        return (ReusableMachineTemplate)this.addOptionalOptions(TemplateOptions.Builder.tags(Arrays.asList(tags)));
    }

    public ReusableMachineTemplate metadataOptional(String key, String value) {
        return (ReusableMachineTemplate)this.addOptionalOptions(TemplateOptions.Builder.userMetadata((String)key, (String)value));
    }

    public ReusableMachineTemplate metadataOptional(Map<String, String> m) {
        return (ReusableMachineTemplate)this.addOptionalOptions(TemplateOptions.Builder.userMetadata(m));
    }

    @Override
    public String toString() {
        String s = this.makeNonTrivialArgumentsString();
        return (this.name != null ? this.name : "Template") + " [ " + s + " ]";
    }
}

