/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb.connection;

import com.mongodb.bulk.UpdateRequest;
import com.mongodb.bulk.WriteRequest;
import com.mongodb.connection.MessageSettings;
import com.mongodb.connection.RequestMessage;
import com.mongodb.internal.validator.CollectibleDocumentFieldNameValidator;
import com.mongodb.internal.validator.NoOpFieldNameValidator;
import com.mongodb.internal.validator.UpdateFieldNameValidator;
import java.util.List;
import org.bson.io.BsonOutput;

class UpdateMessage
extends RequestMessage {
    private final List<UpdateRequest> updates;

    public UpdateMessage(String collectionName, List<UpdateRequest> updates, MessageSettings settings) {
        super(collectionName, RequestMessage.OpCode.OP_UPDATE, settings);
        this.updates = updates;
    }

    @Override
    protected RequestMessage encodeMessageBody(BsonOutput bsonOutput, int messageStartPosition) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeCString(this.getCollectionName());
        UpdateRequest updateRequest = this.updates.get(0);
        int flags = 0;
        if (updateRequest.isUpsert()) {
            flags |= 1;
        }
        if (updateRequest.isMulti()) {
            flags |= 2;
        }
        bsonOutput.writeInt32(flags);
        this.addDocument(updateRequest.getFilter(), bsonOutput, new NoOpFieldNameValidator());
        if (updateRequest.getType() == WriteRequest.Type.REPLACE) {
            this.addCollectibleDocument(updateRequest.getUpdate(), bsonOutput, new CollectibleDocumentFieldNameValidator());
        } else {
            int bufferPosition = bsonOutput.getPosition();
            this.addDocument(updateRequest.getUpdate(), bsonOutput, new UpdateFieldNameValidator());
            if (bsonOutput.getPosition() == bufferPosition + 5) {
                throw new IllegalArgumentException("Invalid BSON document for an update");
            }
        }
        if (this.updates.size() == 1) {
            return null;
        }
        return new UpdateMessage(this.getCollectionName(), this.updates.subList(1, this.updates.size()), this.getSettings());
    }
}

