/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.openshift.api.model;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.openshift.api.model.NamedTagEventList;
import io.fabric8.openshift.api.model.NamedTagEventListFluent;
import io.fabric8.openshift.api.model.TagEvent;
import io.fabric8.openshift.api.model.TagEventBuilder;
import io.fabric8.openshift.api.model.TagEventCondition;
import io.fabric8.openshift.api.model.TagEventConditionBuilder;
import io.fabric8.openshift.api.model.TagEventConditionFluentImpl;
import io.fabric8.openshift.api.model.TagEventFluentImpl;
import java.util.ArrayList;
import java.util.List;

public class NamedTagEventListFluentImpl<A extends NamedTagEventListFluent<A>>
extends BaseFluent<A>
implements NamedTagEventListFluent<A> {
    private List<VisitableBuilder<? extends TagEventCondition, ?>> conditions = new ArrayList();
    private List<VisitableBuilder<? extends TagEvent, ?>> items = new ArrayList();
    private String tag;

    public NamedTagEventListFluentImpl() {
    }

    public NamedTagEventListFluentImpl(NamedTagEventList instance) {
        this.withConditions(instance.getConditions());
        this.withItems(instance.getItems());
        this.withTag(instance.getTag());
    }

    @Override
    public A addToConditions(TagEventCondition ... items) {
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.add(builder);
            this.conditions.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromConditions(TagEventCondition ... items) {
        for (TagEventCondition item : items) {
            TagEventConditionBuilder builder = new TagEventConditionBuilder(item);
            this._visitables.remove(builder);
            this.conditions.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<TagEventCondition> getConditions() {
        return NamedTagEventListFluentImpl.build(this.conditions);
    }

    @Override
    public A withConditions(List<TagEventCondition> conditions) {
        this._visitables.removeAll(this.conditions);
        this.conditions.clear();
        if (conditions != null) {
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withConditions(TagEventCondition ... conditions) {
        this.conditions.clear();
        if (conditions != null) {
            for (TagEventCondition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)this;
    }

    @Override
    public NamedTagEventListFluent.ConditionsNested<A> addNewCondition() {
        return new ConditionsNestedImpl();
    }

    @Override
    public NamedTagEventListFluent.ConditionsNested<A> addNewConditionLike(TagEventCondition item) {
        return new ConditionsNestedImpl(item);
    }

    @Override
    public A addToItems(TagEvent ... items) {
        for (TagEvent item : items) {
            TagEventBuilder builder = new TagEventBuilder(item);
            this._visitables.add(builder);
            this.items.add(builder);
        }
        return (A)this;
    }

    @Override
    public A removeFromItems(TagEvent ... items) {
        for (TagEvent item : items) {
            TagEventBuilder builder = new TagEventBuilder(item);
            this._visitables.remove(builder);
            this.items.remove(builder);
        }
        return (A)this;
    }

    @Override
    public List<TagEvent> getItems() {
        return NamedTagEventListFluentImpl.build(this.items);
    }

    @Override
    public A withItems(List<TagEvent> items) {
        this._visitables.removeAll(this.items);
        this.items.clear();
        if (items != null) {
            for (TagEvent item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public A withItems(TagEvent ... items) {
        this.items.clear();
        if (items != null) {
            for (TagEvent item : items) {
                this.addToItems(item);
            }
        }
        return (A)this;
    }

    @Override
    public NamedTagEventListFluent.ItemsNested<A> addNewItem() {
        return new ItemsNestedImpl();
    }

    @Override
    public NamedTagEventListFluent.ItemsNested<A> addNewItemLike(TagEvent item) {
        return new ItemsNestedImpl(item);
    }

    @Override
    public A addNewItem(String created, String dockerImageReference, Long generation, String image) {
        return this.addToItems(new TagEvent(created, dockerImageReference, generation, image));
    }

    @Override
    public String getTag() {
        return this.tag;
    }

    @Override
    public A withTag(String tag) {
        this.tag = tag;
        return (A)this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamedTagEventListFluentImpl that = (NamedTagEventListFluentImpl)o;
        if (this.conditions != null ? !this.conditions.equals(that.conditions) : that.conditions != null) {
            return false;
        }
        if (this.items != null ? !this.items.equals(that.items) : that.items != null) {
            return false;
        }
        return !(this.tag != null ? !this.tag.equals(that.tag) : that.tag != null);
    }

    public class ItemsNestedImpl<N>
    extends TagEventFluentImpl<NamedTagEventListFluent.ItemsNested<N>>
    implements NamedTagEventListFluent.ItemsNested<N>,
    Nested<N> {
        private final TagEventBuilder builder;

        ItemsNestedImpl(TagEvent item) {
            this.builder = new TagEventBuilder(this, item);
        }

        ItemsNestedImpl() {
            this.builder = new TagEventBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamedTagEventListFluentImpl.this.addToItems(this.builder.build());
        }

        @Override
        public N endItem() {
            return this.and();
        }
    }

    public class ConditionsNestedImpl<N>
    extends TagEventConditionFluentImpl<NamedTagEventListFluent.ConditionsNested<N>>
    implements NamedTagEventListFluent.ConditionsNested<N>,
    Nested<N> {
        private final TagEventConditionBuilder builder;

        ConditionsNestedImpl(TagEventCondition item) {
            this.builder = new TagEventConditionBuilder(this, item);
        }

        ConditionsNestedImpl() {
            this.builder = new TagEventConditionBuilder(this);
        }

        @Override
        public N and() {
            return (N)NamedTagEventListFluentImpl.this.addToConditions(this.builder.build());
        }

        @Override
        public N endCondition() {
            return this.and();
        }
    }
}

