/*
 * Decompiled with CFR 0.152.
 */
package org.jclouds.packet.compute.options;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import org.jclouds.compute.options.TemplateOptions;

public class PacketTemplateOptions
extends TemplateOptions
implements Cloneable {
    private Map<String, String> features = ImmutableMap.of();
    private boolean locked = false;
    private String billingCycle = "hourly";
    private String userData = "";

    public PacketTemplateOptions features(Map<String, String> features) {
        this.features = ImmutableMap.copyOf((Map)((Map)Preconditions.checkNotNull(features, (Object)"features cannot be null")));
        return this;
    }

    public PacketTemplateOptions locked(boolean locked) {
        this.locked = locked;
        return this;
    }

    public PacketTemplateOptions billingCycle(String billingCycle) {
        this.billingCycle = billingCycle;
        return this;
    }

    public PacketTemplateOptions userData(String userData) {
        this.userData = userData;
        return this;
    }

    public Map<String, String> getFeatures() {
        return this.features;
    }

    public boolean isLocked() {
        return this.locked;
    }

    public String getBillingCycle() {
        return this.billingCycle;
    }

    public String getUserData() {
        return this.userData;
    }

    public PacketTemplateOptions clone() {
        PacketTemplateOptions options = new PacketTemplateOptions();
        this.copyTo(options);
        return options;
    }

    public void copyTo(TemplateOptions to) {
        super.copyTo(to);
        if (to instanceof PacketTemplateOptions) {
            PacketTemplateOptions eTo = (PacketTemplateOptions)PacketTemplateOptions.class.cast(to);
            eTo.features(this.features);
            eTo.locked(this.locked);
            eTo.billingCycle(this.billingCycle);
            eTo.userData(this.userData);
        }
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.features, this.locked, this.billingCycle, this.userData});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PacketTemplateOptions other = (PacketTemplateOptions)obj;
        return super.equals((Object)other) && Objects.equal((Object)this.locked, (Object)other.locked) && Objects.equal((Object)this.billingCycle, (Object)other.billingCycle) && Objects.equal((Object)this.userData, (Object)other.userData) && Objects.equal(this.features, other.features);
    }

    public MoreObjects.ToStringHelper string() {
        MoreObjects.ToStringHelper toString = super.string().omitNullValues();
        if (!this.features.isEmpty()) {
            toString.add("features", this.features);
        }
        toString.add("locked", this.locked);
        toString.add("billingCycle", (Object)this.billingCycle);
        toString.add("userData", (Object)this.userData);
        return toString;
    }

    public static class Builder {
        public static PacketTemplateOptions features(Map<String, String> features) {
            PacketTemplateOptions options = new PacketTemplateOptions();
            return options.features(features);
        }

        public static PacketTemplateOptions locked(boolean locked) {
            PacketTemplateOptions options = new PacketTemplateOptions();
            return options.locked(locked);
        }

        public static PacketTemplateOptions billingCycle(String billingCycle) {
            PacketTemplateOptions options = new PacketTemplateOptions();
            return options.billingCycle(billingCycle);
        }

        public static PacketTemplateOptions userData(String userData) {
            PacketTemplateOptions options = new PacketTemplateOptions();
            return options.userData(userData);
        }
    }
}

