/*
 * Decompiled with CFR 0.152.
 */
package org.apache.brooklyn.entity.webapp.nodejs;

import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.util.List;
import org.apache.brooklyn.api.catalog.Catalog;
import org.apache.brooklyn.api.entity.ImplementedBy;
import org.apache.brooklyn.config.ConfigKey;
import org.apache.brooklyn.core.config.ConfigKeys;
import org.apache.brooklyn.core.entity.Attributes;
import org.apache.brooklyn.core.location.PortRanges;
import org.apache.brooklyn.core.sensor.PortAttributeSensorAndConfigKey;
import org.apache.brooklyn.entity.software.base.SoftwareProcess;
import org.apache.brooklyn.entity.webapp.WebAppService;
import org.apache.brooklyn.entity.webapp.nodejs.NodeJsWebAppServiceImpl;
import org.apache.brooklyn.util.core.flags.SetFromFlag;

@Catalog(name="Node.JS Application", description="Node.js is a cross-platform runtime environment for server-side and networking applications. Node.js applications are written in JavaScriptq", iconUrl="classpath:///nodejs-logo.png")
@ImplementedBy(value=NodeJsWebAppServiceImpl.class)
public interface NodeJsWebAppService
extends SoftwareProcess,
WebAppService {
    public static final ConfigKey<String> SUGGESTED_VERSION = ConfigKeys.newConfigKeyWithDefault((ConfigKey)SoftwareProcess.SUGGESTED_VERSION, (Object)"stable");
    @SetFromFlag(value="httpPort")
    public static final PortAttributeSensorAndConfigKey HTTP_PORT = ConfigKeys.newPortSensorAndConfigKeyWithDefault((PortAttributeSensorAndConfigKey)Attributes.HTTP_PORT, (Object)PortRanges.fromInteger((int)3000));
    @SetFromFlag(value="gitRepoUrl")
    public static final ConfigKey<String> APP_GIT_REPOSITORY_URL = ConfigKeys.newStringConfigKey((String)"nodejs.gitRepo.url", (String)"The Git repository where the application is hosted");
    @SetFromFlag(value="archiveUrl")
    public static final ConfigKey<String> APP_ARCHIVE_URL = ConfigKeys.newStringConfigKey((String)"nodejs.archive.url", (String)"The URL where the application archive is hosted");
    @SetFromFlag(value="appFileName")
    public static final ConfigKey<String> APP_FILE = ConfigKeys.newStringConfigKey((String)"nodejs.app.fileName", (String)"The NodeJS application file to start", (String)"app.js");
    @SetFromFlag(value="appName")
    public static final ConfigKey<String> APP_NAME = ConfigKeys.newStringConfigKey((String)"nodejs.app.name", (String)"The name of the NodeJS application");
    @SetFromFlag(value="appCommand")
    public static final ConfigKey<String> APP_COMMAND = ConfigKeys.newStringConfigKey((String)"nodejs.app.command", (String)"Command to start the NodeJS application (defaults to node)", (String)"node");
    @SetFromFlag(value="appCommandLine")
    public static final ConfigKey<String> APP_COMMAND_LINE = ConfigKeys.newStringConfigKey((String)"nodejs.app.commandLine", (String)"Replacement command line to start the NodeJS application (ignores command and file if set)");
    @SetFromFlag(value="nodePackages")
    public static final ConfigKey<List<String>> NODE_PACKAGE_LIST = ConfigKeys.newConfigKey((TypeToken)new TypeToken<List<String>>(){}, (String)"nodejs.packages", (String)"The NPM packages to install", (Object)ImmutableList.of());
    public static final ConfigKey<String> SERVICE_UP_PATH = ConfigKeys.newStringConfigKey((String)"nodejs.serviceUp.path", (String)"Path to use when checking the NodeJS application is running", (String)"/");
    @SetFromFlag(value="useHttpMonitoring")
    public static final ConfigKey<Boolean> USE_HTTP_MONITORING = ConfigKeys.newConfigKey((String)"httpMonitoring.enabled", (String)"HTTP(S) monitoring enabled", (Object)Boolean.TRUE);

    public Integer getHttpPort();
}

